//---------------------------------------------------------------------------
/* InformReceiveDemandReplyMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformReceiveDemandReplyMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private ObjId objId;
  private long offset;
  private long length;
  private long requestId;
    private AcceptStamp as;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformReceiveDemandReplyMsg(NodeId senderNodeId, ObjId objId, long offset, 
                                     long length, long requestId, AcceptStamp as){
    this.senderNodeId = senderNodeId;
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.requestId = requestId;
    this.as = as;
  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informReceiveDemandReply(senderNodeId, objId, offset, 
                                     length, requestId, as);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformReceiveDemandReplyMsg: " + senderNodeId +", " +  objId + ", " 
	+ offset + ", " + length +  ", " + requestId + ", " + as.toString();
  }
}

//---------------------------------------------------------------------------
/* $Log: InformReceiveDemandReplyMsg.java,v $
/* Revision 1.2  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
