//---------------------------------------------------------------------------
/* InformReceiveInvalMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformReceiveInvalMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private ObjId objId;
  private long offset;
  private long length;
  private AcceptStamp as;
  private boolean isBound;
  private boolean isEmbargoed;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformReceiveInvalMsg(NodeId senderNodeId, ObjId objId, long offset, 
                               long length, AcceptStamp as, 
                               boolean isBound, boolean isEmbargoed) {
    this.senderNodeId = senderNodeId;
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.as = as;
    this.isBound = isBound;
    this.isEmbargoed = isEmbargoed;
  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informReceiveInval(senderNodeId, objId, offset, 
                               length, as, isBound, isEmbargoed);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformReceiveInvalMsg: " + senderNodeId +", " +  objId + ", " 
      + offset + ", " + length +  ", " + as + ", " + isBound + ", "
      + isEmbargoed;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformReceiveInvalMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
