//---------------------------------------------------------------------------
/* InformSubscribeBodyRemovedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformSubscribeBodyRemovedMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformSubscribeBodyRemovedMsg(NodeId senderNodeId,
                                       SubscriptionSet ss){
    this.senderNodeId = senderNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informSubscribeBodyRemoved(senderNodeId, ss); 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformSubscribeBodyRemovedMsg: " + senderNodeId +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformSubscribeBodyRemovedMsg.java,v $
/* Revision 1.1  2006/10/31 21:43:33  nalini
/* added control msgs to body streams
/*
 */
//---------------------------------------------------------------------------
