//---------------------------------------------------------------------------
/* InformSubscribeBodySucceededMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformSubscribeBodySucceededMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformSubscribeBodySucceededMsg(NodeId senderNodeId,
                                       SubscriptionSet ss){
    this.senderNodeId = senderNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informSubscribeBodySucceeded(senderNodeId, ss); 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformSubscribeBodySucceededMsg: " + senderNodeId +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformSubscribeBodySucceededMsg.java,v $
/* Revision 1.1  2006/10/31 21:43:33  nalini
/* added control msgs to body streams
/*
 */
//---------------------------------------------------------------------------
