//---------------------------------------------------------------------------
/* InformSubscribeInvalAttachedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformSubscribeInvalAttachedMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformSubscribeInvalAttachedMsg(NodeId senderNodeId,
                                          SubscriptionSet ss){
    this.senderNodeId = senderNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informSubscribeInvalAttached(senderNodeId, ss); 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformSubscribeInvalAttachedMsg: " + senderNodeId +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformSubscribeInvalAttachedMsg.java,v $
/* Revision 1.1  2007/03/08 21:51:26  nalini
/* added inval attached msg
/*
 */
//---------------------------------------------------------------------------
