//---------------------------------------------------------------------------
/* InformSubscribeInvalFailedMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformSubscribeInvalFailedMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformSubscribeInvalFailedMsg(NodeId senderNodeId,
                                       SubscriptionSet ss){
    this.senderNodeId = senderNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informSubscribeInvalFailed(senderNodeId, ss); 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformSubscribeInvalFailedMsg: " + senderNodeId +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformSubscribeInvalFailedMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
