//---------------------------------------------------------------------------
/* InformSubscribeInvalSucceededMsg.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------


public class InformSubscribeInvalSucceededMsg extends ControllerInformMessage {
  
  private NodeId senderNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
  public InformSubscribeInvalSucceededMsg(NodeId senderNodeId,
                                          SubscriptionSet ss){
    this.senderNodeId = senderNodeId;
    this.ss = ss;

  }
  
//--------------------------------------------------------------------------
// handleMessage method
//--------------------------------------------------------------------------
  public void handleMessage(P2Runtime runtime) {
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss); 
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "InformSubscribeInvalSucceededMsg: " + senderNodeId +", " +  ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: InformSubscribeInvalSucceededMsg.java,v $
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
