//---------------------------------------------------------------------------
/* InformalTest.java
 * 
 * Carries out informal testing of the p2 related classes
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class InformalTest{

  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){

    String path = "test" + File.separatorChar + "RuntimeTest.db";
    String configPath = "test" + File.separatorChar + "RuntimeTest.config";
    String p2ConfigPath = "test" + File.separatorChar + "RuntimeTest.p2.config";    
    setupConfig(configPath, p2ConfigPath);
 

    NodeId myNodeId = new NodeId(0);
    Policy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();

    try{
      //testBodySubscriptions(runtime);
      //testInvalSubscriptions(runtime);
      // testUpdateSubscriptions(runtime);
      testDemandReads(runtime);
      System.out.println("Done!");
    }catch(Exception e){
      e.printStackTrace();
    }
    
  }


  private static void setupConfig(String configPath, String p2ConfigPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

   Config.addOneNodeConfig(new NodeId(1),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            "/tmp/ufs1",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

   Config.writeToFile(configPath);

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 1000, 500, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 1000, 500, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }

  private static void testBodySubscriptions(P2Runtime runtime) throws Exception{
    //
    // test body subscripitons -  note: all the rmiClient commands have been
    // need to be commented otu for this test
    //
    
    NodeId senderNodeId = new NodeId(1);
    SubscriptionSet ss1 = SubscriptionSet.makeSubscriptionSet("/a");
    SubscriptionSet ss2 = SubscriptionSet.makeSubscriptionSet("/b");
    SubscriptionSet ss3 = SubscriptionSet.makeSubscriptionSet("/c");
    SubscriptionSet ss4 = SubscriptionSet.makeSubscriptionSet("/d");
    SubscriptionSet ss5 = SubscriptionSet.makeSubscriptionSet("/e");
    SubscriptionSet ss6 = SubscriptionSet.makeSubscriptionSet("/f");

    runtime.addBodySubscription(senderNodeId, ss1);
    runtime.addBodySubscription(senderNodeId, ss2);
    Thread.currentThread().sleep(600);
    runtime.addBodySubscription(senderNodeId, ss3);
    runtime.addBodySubscription(senderNodeId, ss4);
    runtime.addBodySubscription(senderNodeId, ss5);

    Thread.currentThread().sleep(50);    
    runtime.informSubscribeBodySucceeded(senderNodeId, ss1);
    runtime.informSubscribeBodySucceeded(senderNodeId, ss5);

    runtime.informOutgoingSubscribeBodyInitiated(senderNodeId, ss6);
    Thread.currentThread().sleep(100);
    runtime.informOutgoingSubscribeBodyTerminated(senderNodeId, ss6);
  }

 private static void testInvalSubscriptions(P2Runtime runtime) throws Exception{
    //
    // test inval subscripitons -  note: all the rmiClient commands have been
    // need to be commented otu for this test
    //
    
    NodeId senderNodeId = new NodeId(1);
    SubscriptionSet ss1 = SubscriptionSet.makeSubscriptionSet("/a");
    SubscriptionSet ss2 = SubscriptionSet.makeSubscriptionSet("/b");
    SubscriptionSet ss3 = SubscriptionSet.makeSubscriptionSet("/c");
    SubscriptionSet ss4 = SubscriptionSet.makeSubscriptionSet("/d");
    SubscriptionSet ss5 = SubscriptionSet.makeSubscriptionSet("/e");
    SubscriptionSet ss6 = SubscriptionSet.makeSubscriptionSet("/f");

    runtime.addInvalSubscription(senderNodeId, ss1, false);
    runtime.addInvalSubscription(senderNodeId, ss2, false);
    runtime.addInvalSubscription(senderNodeId, ss3, false);
    runtime.addInvalSubscription(senderNodeId, ss4, false);
    runtime.addInvalSubscription(senderNodeId, ss5, false);

    Thread.currentThread().sleep(500);    
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss1);
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss5);
    Thread.currentThread().sleep(500);    

    runtime.informSubscribeInvalFailed(senderNodeId, ss1);
    runtime.informOutgoingSubscribeInvalInitiated(senderNodeId, ss6);
    Thread.currentThread().sleep(100);
    runtime.informOutgoingSubscribeInvalTerminated(senderNodeId, ss6);
  }

/* 

 private static void testUpdateSubscriptions(P2Runtime runtime) throws Exception{
    //
    // test Inval subscripitons -  note: all the rmiClient commands have been
    // need to be commented otu for this test
    //
    
    NodeId senderNodeId = new NodeId(1);
    SubscriptionSet ss1 = SubscriptionSet.makeSubscriptionSet("/a");
    SubscriptionSet ss2 = SubscriptionSet.makeSubscriptionSet("/b");
    SubscriptionSet ss3 = SubscriptionSet.makeSubscriptionSet("/c");
    SubscriptionSet ss4 = SubscriptionSet.makeSubscriptionSet("/d");
    SubscriptionSet ss5 = SubscriptionSet.makeSubscriptionSet("/e");
    SubscriptionSet ss6 = SubscriptionSet.makeSubscriptionSet("/f");

    runtime.addUpdateSubscription(senderNodeId, ss1);
    runtime.addUpdateSubscription(senderNodeId, ss2);
    runtime.addUpdateSubscription(senderNodeId, ss3);
    runtime.addUpdateSubscription(senderNodeId, ss4);
    runtime.addUpdateSubscription(senderNodeId, ss5);
    runtime.addUpdateSubscription(senderNodeId, ss6);

    Thread.currentThread().sleep(50);    
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss1);
    runtime.informSubscribeBodySucceeded(senderNodeId, ss2);
    Thread.currentThread().sleep(50);    
    runtime.informSubscribeBodySucceeded(senderNodeId, ss1);
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss2);
    // by this point ss1 and ss2 would have been added as update subs


    Thread.currentThread().sleep(1000);    
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss3);
    runtime.informSubscribeBodySucceeded(senderNodeId, ss4);
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss5);
    runtime.informSubscribeBodySucceeded(senderNodeId, ss6);
    Thread.currentThread().sleep(1000);  
    runtime.informSubscribeBodySucceeded(senderNodeId, ss3);
    runtime.informSubscribeInvalSucceeded(senderNodeId, ss4);
    // by this point ss3 and ss4 would have been added as update subs
        
    runtime.informSubscribeInvalFailed(senderNodeId, ss5);
    runtime.informSubscribeBodyRemoved(senderNodeId, ss6);

    runtime.informSubscribeInvalFailed(senderNodeId, ss1);
    runtime.informSubscribeBodyRemoved(senderNodeId, ss2);
  }   
*/ 
private static void testDemandReads(P2Runtime runtime) throws Exception{
    //
    // test Inval subscripitons -  note: all the rmiClient commands have been
    // need to be commented otu for this test
    //
    
    NodeId senderNodeId = new NodeId(1);

    ObjId obj1 = new ObjId("/1");
    ObjId obj2 = new ObjId("/2");
    ObjId obj3 = new ObjId("/3");
    ObjId obj4 = new ObjId("/4");
    ObjId obj5 = new ObjId("/5");
    AcceptStamp as = new AcceptStamp(-1, senderNodeId);
    runtime.demandRead(senderNodeId, obj1, 0, 10, as);
    runtime.demandRead(senderNodeId, obj2, 0, 10, as);
    runtime.demandRead(senderNodeId, obj3, 0, 10, as);
    runtime.demandRead(senderNodeId, obj4, 0, 10, as);
    runtime.demandRead(senderNodeId, obj5, 0, 10, as);

    runtime.informReceiveDemandReply(senderNodeId, obj1, 0, 10, 0, as);    
    Thread.currentThread().sleep(500);
    runtime.informReceiveDemandReply(senderNodeId, obj2, 0, 10, 1, as);

  }      
}


//---------------------------------------------------------------------------
/* $Log: InformalTest.java,v $
/* Revision 1.13  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.12  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.11  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.10  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.9  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.8  2006/10/31 21:43:33  nalini
/* added control msgs to body streams
/*
/* Revision 1.7  2006/10/02 23:23:39  nalini
/* synchronization support added
/*
/* Revision 1.6  2006/08/09 18:52:16  dahlin
/* Fixed Makefile to be portable to cygwin by fixing classpath definitions; fixed P2Runtime/Runtime v. java.lang.Runtime conflict by moving P2Runtime/Runtime to P2Runtime/P2Runtime
/*
/* Revision 1.5  2006/06/02 22:40:02  nalini
/* merged support for adding and removing ss for outgoing body streams
/*
/* Revision 1.4.2.1  2006/06/02 22:18:39  nalini
/* Supports addition and removeal of SS from Outgoing Body Streams
/*
/* Revision 1.4  2006/04/23 20:06:42  nalini
/* *** empty log message ***
/*
/* Revision 1.1  2006/04/21 02:54:54  nalini
/* Initial version of P2 runtime. (merged with jiandan's callback code)
/*
 */
//---------------------------------------------------------------------------
