//---------------------------------------------------------------------------
/* InvalSubscription.java
 * 
 * Invalidation  Subscriptions
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class InvalSubscription extends Subscription {

  /* Note: this variable is not use for comparison */
  boolean catchupWithCP = false;

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public 
  InvalSubscription(NodeId sNode, NodeId rNode, SubscriptionSet s, 
                    boolean catchupWithCP){
    super(sNode, rNode, s);
    this.catchupWithCP = catchupWithCP;
  }


//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public 
  InvalSubscription(NodeId sNode, NodeId rNode, SubscriptionSet s){
    super(sNode, rNode, s);
  }

//---------------------------------------------------------------------------
// getCatchupType
//  -- true : CP
//  -- false : LOG
//---------------------------------------------------------------------------
 public
 boolean getCatchupType() {
   return catchupWithCP;
 }

//---------------------------------------------------------------------------
// clone
//---------------------------------------------------------------------------
  public Object clone() {
    InvalSubscription s = new InvalSubscription((NodeId)senderNode.clone(),
                                                (NodeId)receiverNode.clone(), 
                                                (SubscriptionSet)SS.clone(),
                                                catchupWithCP);
    s.numTries = this.numTries;
    if(this.mostRecentException != null) {
      s.mostRecentException = new Exception(this.mostRecentException);
    }
    return s;
  }   

}

//---------------------------------------------------------------------------
/* $Log: InvalSubscription.java,v $
/* Revision 1.4  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.3  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.2  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/*
*/
//---------------------------------------------------------------------------
