//---------------------------------------------------------------------------
/* NullPolicy.java
 * 
 *  Does nothing
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class NullPolicy extends Policy{

  private boolean dbg = false;
 

//---------------------------------------------------------------------------
// interface to interact with safety module
//---------------------------------------------------------------------------

  // receiveMsg: called by safety to send a msg to liveness policy
  public void receiveMsg(String[] msg){
  }

//---------------------------------------------------------------------------
// starts the policy layer
//---------------------------------------------------------------------------
  public void start(){
  }


//---------------------------------------------------------------------------
// shuts down the policy layer
//---------------------------------------------------------------------------
  public void shutdown(){
  }

//---------------------------------------------------------------------------
// Runs simple reads and writes
//---------------------------------------------------------------------------
  public static void main(String[] argv){
    //
    // Set up config
    //
    String path = "test" + File.separatorChar + "NullPolicyTest.db";
    String configPath = "test" + File.separatorChar + "NullPolicyTest.config";
    String p2ConfigPath = "test" + File.separatorChar + "NullPolicyTest.p2.config";
    int id = 42;
    NodeId myNodeId = new NodeId((long)id);
    Config.makeOneNodeTestConfig(configPath, id, "/*", 5000, 5001, 5002, 5003, 5004, path, 42, 5005, 100000);
    Config.readConfig(configPath);
    P2Config.makeOneNodeTestConfig(p2ConfigPath, id, 10, 10, 500, 500, 5, 5, 5, 5, 5);
    P2Config.readConfig(p2ConfigPath);

    
    Policy policy = new NullPolicy();
    P2Runtime runtime =  new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    AllReadBlockAllWriteBoundInterface lInterface = 
      new AllReadBlockAllWriteBoundInterface(runtime.getController(), runtime.getCore());
   
    try{
    //
    // test simple reads and writes
    // 
    final long SIZE = 100;
    long offset = 100;
    byte b[] = new byte[(int)SIZE];
    for(int i = 0; i < SIZE; i++){
      b[i]=(byte)65;
    }
    
    
    ObjId o1 = new ObjId("/" + id + "/1");
    ObjId o2 = new ObjId("/" + id + "/2");
    ObjId o3 = new ObjId("/" + id + "/3");

    lInterface.write(o1, 0, SIZE, b);
    lInterface.write(o2, 0, SIZE, b);
    lInterface.write(o3, 0, SIZE, b);

    System.out.println(o1 + ":" + lInterface.read(o1, 0, SIZE));
    System.out.println(o2 + ":" + lInterface.read(o2, 0, SIZE));
    System.out.println(o3 + ":" + lInterface.read(o3, 0, SIZE));


    }catch(Exception e){
      e.printStackTrace();
    }
    
  }  

//---------------------------------------------------------------------------
// information of practi events
//---------------------------------------------------------------------------

  public void informLocalReadInvalid(ObjId objId, long offset, long length,
				     AcceptStamp inval){
    Env.dprintln(dbg, "informLocalReadInvalid:"+objId+":"+offset+":"+length);
  }

  public void informLocalReadImprecise(ObjId objId, long offset, long length){
    Env.dprintln(dbg, "informLocalReadImprecise:"+objId+":"+offset+":"+length);
  }

  public void informLocalWrite(ObjId objId, long offset, long length, AcceptStamp as,
                               boolean isBound, boolean isEmbargoed){
    Env.dprintln(dbg, "informLocalWrite"+objId+":"+offset+":"+length);
  }

  public void informLocalDelete(ObjId objId){
    Env.dprintln(dbg, "informLocalDelete"+objId);
  }

  public void informReceiveInval(NodeId senderNodeId, ObjId objId, long offset, long length,
                                 AcceptStamp as, boolean isBound, boolean isEmbargoed){
    Env.dprintln(dbg, "informReceiveInval"+objId+":"+offset+":"+length+":as="+as);
}


    public void informDemandReadSuccess(NodeId senderNodeId, ObjId objId, long offset,
				      long length,
				      AcceptStamp as) {
      Env.dprintln(dbg, "informDemandReadSuccess"+senderNodeId+":"+objId+":"+offset+":"+length 
		   + ":" + as.toString());
 
    
  }

  public void informDemandReadFailedMiss(NodeId senderNodeId, ObjId objId, 
                                         long offset, long length, 
					 AcceptStamp as) {
      Env.dprintln(dbg, "informDemandReadFailedMiss"+senderNodeId+":"+objId
		   +":"+offset+":"+length + ":" + as.toString());
  }
 
  public void informDemandReadFailedMaxRetries(NodeId senderNodeId, ObjId objId, 
                                               long offset,long length,
					       AcceptStamp as) {
    Env.dprintln(dbg, "informDemandReadFailedMaxRetries"
		 +senderNodeId+":"+objId+":"+offset+":"+length + ":" + as.toString());
  }

  

  public void recvSyncReply(NodeId senderNodeId, AcceptStamp acceptStamp) {
    Env.dprintln(dbg, "recvSyncReply "+senderNodeId+":"+acceptStamp);
  }

//---------------------------------------------------------------------------
// Subscription add events
//---------------------------------------------------------------------------

  public void informAddedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAddedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAttachedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAttachedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informAddedBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informAddedOutgoingInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "InformAddedOutgoingBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

//---------------------------------------------------------------------------
// Subscription removed events
//---------------------------------------------------------------------------

  public void informRemovedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informRemovedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedBodySbuscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }
  
  public void informRemovedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedOutgoingInvalSubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informRemovedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss){
    Env.dprintln(dbg, "informRemovedOutgiongBodySubscription"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

//---------------------------------------------------------------------------
// Subscription failed
//---------------------------------------------------------------------------
 
  public void informAddInvalSubscriptionFailed(NodeId senderNodeId, 
                                               NodeId receiverNodeId, 
                                               SubscriptionSet ss){
    Env.dprintln(dbg, "informAddInvalSubscriptionFailed"+senderNodeId+":"+receiverNodeId+":"+ss);
  }

  public void informAddBodySubscriptionFailed(NodeId senderNodeId, 
                                              NodeId receiverNodeId, 
                                              SubscriptionSet ss){
   Env.dprintln(dbg, "informAddBodySubscriptionFailed"+senderNodeId+":"+receiverNodeId+":"+ss);
  }
  
}
//---------------------------------------------------------------------------
/* $Log: NullPolicy.java,v $
/* Revision 1.16  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
/* Revision 1.15  2007/03/09 21:46:09  nalini
/* added 2 events: informAddInvalSubscriptionFailed & informAddBodySubscriptionFailed
/*
/* Revision 1.14  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.13  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.12  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.11  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.10  2006/10/02 23:23:39  nalini
/* synchronization support added
/*
/* Revision 1.9  2006/09/26 05:34:09  nalini
/* added sync interface to policy and runtime
/*
/* Revision 1.8  2006/08/24 23:08:53  nalini
/* Simple unit test created for P2Runtime
/*
*/
//---------------------------------------------------------------------------
