//---------------------------------------------------------------------------
/* ObjReaderWriterFactory
 * 
 * creates objReaderWriter as needed
 * Note: only 1 objReaderWriter is created per objId
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.util.*;

public class ObjReaderWriterFactory {
  private Hashtable objRWTable;
  private LocalInterface li;

  public ObjReaderWriterFactory(LocalInterface li){
    objRWTable = new Hashtable();
    this.li = li;
  }


  public ObjReaderWriter 
  getObjReaderWriter(ObjId objId){
    ObjReaderWriter objRW = (ObjReaderWriter)objRWTable.get(objId);
    if(objRW == null) {
      objRW = new ObjReaderWriter(li, objId);
      objRWTable.put(objId, objRW);
    }
    return objRW;
  }

  public void
  removeObjReaderWriter(ObjId objId){
    objRWTable.remove(objId);
  }

  // for debugging/testing purposes
  public void 
  printFactoryTable() {
    System.out.println(objRWTable.toString());
  }
  
  // for debugging/testing purposes
  public int
  getSize() {
    return objRWTable.size();
  }

}


//---------------------------------------------------------------------------
/* $Log: ObjReaderWriterFactory.java,v $
/* Revision 1.1  2007/07/11 20:25:53  nalini
/* persistent tuple support added
/*
*/
//---------------------------------------------------------------------------
