//---------------------------------------------------------------------------
/* OverlogId.java
 *
 * Represents the overlogId which is in the form
 *    hostname:port
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.Serializable;
import java.util.*;

public class OverlogId implements Comparable, Serializable, Immutable {
 
  private final String hostname;
  private final long port;

    
//-----------------------------------------------------------------------
// Constructor
//-----------------------------------------------------------------------
  
  public OverlogId(String hostname, long port) {
    this.hostname = hostname;
    this.port = port;
  }

//-----------------------------------------------------------------------
// Constructor
//-----------------------------------------------------------------------
  
  public OverlogId(String str) {
    StringTokenizer st = new StringTokenizer(str, ": ");
    this.hostname = st.nextToken();
    this.port = new Long(st.nextToken()).longValue();
  }

//-----------------------------------------------------------------------
// Compare to OverlogIds
//-----------------------------------------------------------------------

  public int compareTo(Object o) {
    int result = 0; 
    OverlogId other = (OverlogId) o;

    result = this.hostname.compareTo(other.hostname) * 1000 + 
      (int)(this.port - other.port);

    return result;
  
  }

//-----------------------------------------------------------------------
// Returns true of o equals this object
//-----------------------------------------------------------------------
  public boolean equals(Object o) {
    if(this == o) {
      return true;
    }

    if(o instanceof OverlogId){
      OverlogId other = (OverlogId) o;
      if (this.hostname.equals(other.hostname) && 
          this.port == other.port) {
        return true;
      }
    }
    return false;
  }

//-----------------------------------------------------------------------
// Returns the hash code of the object
//-----------------------------------------------------------------------
  public int hashCode() {
    return this.toString().hashCode();
  }

//-----------------------------------------------------------------------
// returns the  hostname
//-----------------------------------------------------------------------
  public String getHostname(){
    return hostname;
  }

//-----------------------------------------------------------------------
// returns the  port
//-----------------------------------------------------------------------
  public long getPort(){
    return port;
  }

//-----------------------------------------------------------------------
// String representation of this object
//-----------------------------------------------------------------------
  public String toString(){
    return hostname + ":" + port;
  }

  public static void main(String[] args) {
    OverlogId o1 = new OverlogId("localhost:5000");
    OverlogId o2 = new OverlogId("localhost:5000");
    OverlogId o3 = new OverlogId("localhost:5003");

    System.out.println(o1.equals(o2));
    System.out.println(o1.compareTo(o2));

    System.out.println(o1.equals(o3));
    System.out.println(o1.compareTo(o3));

    Hashtable hash = new Hashtable();
    hash.put(o1, new String("one"));
    hash.put(o2, new String("two"));
    System.out.println(hash);

  }

}
//---------------------------------------------------------------------------
/* $Log: OverlogId.java,v $
/* Revision 1.2  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/*
/* Revision 1.1  2006/09/19 22:18:27  nalini
/* P2 and Practi integration
/*
*/
//---------------------------------------------------------------------------
