//---------------------------------------------------------------------------
/*  OverlogInsertWorker
 *  
 * Takes a tuple from the queue and inserts it into overlog
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------
import java.lang.*;
import java.io.*;

public class OverlogInsertWorker extends Thread {

  private P2JavaWrapper javaWrapper;
  private P2ServerInterface serverInterface;
  private BlockedQueue queue;

  private boolean useServer;

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public OverlogInsertWorker(P2JavaWrapper javaWrapper, BlockedQueue queue){
    this.javaWrapper = javaWrapper;
    this.queue = queue;
    this.useServer = false;
  }
 
//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public OverlogInsertWorker(P2ServerInterface serverInterface, BlockedQueue queue){
    this.serverInterface = serverInterface;
    this.queue = queue;
    this.useServer = true;
  }
//---------------------------------------------------------------------------
// run - gets an item from the queue and inserts it into overlog
//---------------------------------------------------------------------------
 
  public void run(){
    while(true) {
      Tuple tp = (Tuple) queue.getNext();
      if(useServer) {
        serverInterface.insertTuple(tp);
      }else{
        javaWrapper.insertTuple(tp);
      }
    }
  }
}
//---------------------------------------------------------------------------
/* $Log: OverlogInsertWorker.java,v $
/* Revision 1.2  2007/03/16 23:57:35  nalini
/* p2serverinterface added
/*
/* Revision 1.1  2006/09/26 20:24:17  nalini
/* added worker queues to handle insert and watch of tuples in overlog policy
/*
 */
//---------------------------------------------------------------------------

