//---------------------------------------------------------------------------
/*  OverlogThread.java
 *  
 * Starts the overlog file thro' the P2JavaWrapper
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------
import java.lang.*;
import java.io.*;

public class OverlogThread extends Thread {

  private P2JavaWrapper javaWrapper;
  private P2ServerInterface serverInterface;

  private boolean useServer;

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public OverlogThread(P2JavaWrapper javaWrapper){
    this.javaWrapper = javaWrapper;
    useServer = false;
  }
 
//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public OverlogThread(P2ServerInterface serverInterface){
    this.serverInterface = serverInterface;
    useServer=true;
  }
 
//---------------------------------------------------------------------------
// run - starts the Overlog dataflow
//---------------------------------------------------------------------------
 
  public void run(){
    if(useServer) {
      serverInterface.startOverlog();
    } else {
      javaWrapper.startOverlog();
    }
  }
}
//---------------------------------------------------------------------------
/* $Log: OverlogThread.java,v $
/* Revision 1.2  2007/03/16 23:57:35  nalini
/* p2serverinterface added
/*
/* Revision 1.1  2006/09/19 22:18:27  nalini
/* P2 and Practi integration
/*
 */
//---------------------------------------------------------------------------

