//---------------------------------------------------------------------------
/*  OverlogWatchWorker
 *  
 * Takes a tuple from the queue and calls methods in the Overlog Policy
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------
import java.lang.*;
import java.io.*;
import java.util.*;

public class OverlogWatchWorker extends Thread {

  private BlockedQueue overlogWatchQueue;
  private Hashtable tupleHandlers;
  private boolean dbg = false;

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public OverlogWatchWorker(Hashtable tupleHandlers, BlockedQueue overlogWatchQueue){
    this.tupleHandlers = tupleHandlers;
    this.overlogWatchQueue = overlogWatchQueue;
  }
 
//---------------------------------------------------------------------------
// run - gets the next item from the queue and handles it
//---------------------------------------------------------------------------
 
  public void run(){
    while(true) {
      Tuple tp = (Tuple) overlogWatchQueue.getNext();
      if(dbg){
	Env.dprintln(dbg, "OverlogWatchWorker: Received tuple " + tp.toString());
      }
      TupleHandler th = (TupleHandler)tupleHandlers.get(tp.getTupleName());
      
      if(th != null) {
        try{
          th.handleTuple(tp);
        }catch(MalformedTupleException e){
          System.err.println("MalformedTupleException for tuple : " + tp.getTupleName()+
                             "\n check your overlog file " + e);
          assert(false);
        }

      } else {
        System.err.println("Could not find handler for tuple : " + tp.getTupleName());
        assert(false);
      }
    }
  }
}
//---------------------------------------------------------------------------
/* $Log: OverlogWatchWorker.java,v $
/* Revision 1.6  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.5  2006/11/02 21:11:19  zjiandan
/* Fixed some bugs in URAOverlogNode and TupleHandlers.
/*
/* Revision 1.4  2006/11/01 19:26:46  zjiandan
/* Integrate PangaeaFS and NFS interface.
/*
/* Revision 1.3  2006/10/17 23:40:55  nalini
/* minor bug fixes and separated AS into individual components in overlog tuples
/*
/* Revision 1.2  2006/10/16 20:51:49  nalini
/* P2 tuple handler support added
/*
/* Revision 1.1  2006/09/26 20:24:17  nalini
/* added worker queues to handle insert and watch of tuples in overlog policy
/*
 */
//---------------------------------------------------------------------------

