//---------------------------------------------------------------------------
/*  OverlogWatcher
 *  
 * Whenver it receives a tuple from overlog, puts it in a queue
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class OverlogWatcher implements Watcher {

  private BlockedQueue queue;
  private OverlogId myOverlogId;
  boolean dbg = false;

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
  public OverlogWatcher(OverlogId myOverlogId, BlockedQueue queue){
   this.myOverlogId = myOverlogId; 
   this.queue = queue;
  }
 
//---------------------------------------------------------------------------
// receivedTuple - puts it in the queue whenever it receives a tuple
//---------------------------------------------------------------------------

 public synchronized void receivedTuple(Tuple tp){
    //
    // if tuple is not locally generated, ignore it
    //  -- should not happen, but may happen due to 
    //     p2 anamolies
    //

   if(dbg){
     Env.dprintln(dbg, "Overlog watcher received tuple" + tp);
   }

    String tupleLocation = tp.getItem(1);
    if (!tupleLocation.equals(myOverlogId.toString())){
      return;
    }
    
    Tuple tpToAdd = tp;

    if(OverlogPolicy.P2VersionHasSubscribeProblem){
      // convert the issueCommand tuple to an action tuple
      String[] tpA = new String[tp.getSize()-2];
      for(int i=0; i< tpA.length; i++){
        tpA[i]= tp.getItem(i+2);
      }
      tpToAdd = new Tuple(tpA);
      
    }
    
   if(dbg){
     Env.dprintln(dbg, "Overlog watcher:adding tuple to queue");
   }
    queue.add(tpToAdd);
 }

}
//---------------------------------------------------------------------------
/* $Log: OverlogWatcher.java,v $
/* Revision 1.5  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.4  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.3  2006/10/17 23:40:55  nalini
/* minor bug fixes and separated AS into individual components in overlog tuples
/*
/* Revision 1.2  2006/09/26 20:57:06  nalini
/* minor bug fix
/*
/* Revision 1.1  2006/09/26 20:24:17  nalini
/* added worker queues to handle insert and watch of tuples in overlog policy
/*
 */
//---------------------------------------------------------------------------

