//---------------------------------------------------------------------------
/* P2ConfigEntry.java
 * 
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class P2ConfigEntry {
  NodeId nodeId;
  int maxSubRetries; //subscription retries
  int maxDRRetries;  //demand Read retries
  long subTimeout;   //subscription timeout
  long drTimeout;   // demand read timeout
  int bodyWorkers;
  int invalWorkers;
  int demandWorkers;
  int informWorkers;
  int commandWorkers;
  int p2serverPort;
  int p2clientPort;
  String rmiServiceName; //<nodeId>-Runtime
  String rmiURL; // rmi://<DNS>/<rmiServiceName>

  P2ConfigEntry(NodeId nodeId, int maxSubRetries, int maxDRRetries,
                long timeoutSub, long timeoutDr, int bodyWorkers, 
                int invalWorkers, 
                int demandWorkers, int informWorkers,
                int commandWorkers,
                int p2serverPort, int p2clientPort){
    this.nodeId = nodeId;
    this.maxSubRetries = maxSubRetries;
    this.maxDRRetries = maxDRRetries;
    this.subTimeout = timeoutSub;
    this.drTimeout = timeoutDr;
    this.bodyWorkers = bodyWorkers;
    this.invalWorkers = invalWorkers;
    this.demandWorkers = demandWorkers;
    this.informWorkers = informWorkers;
    this.commandWorkers = commandWorkers;
    this.p2serverPort = p2serverPort;
    this.p2clientPort = p2clientPort;
    this.rmiServiceName = nodeId.toString()+"-Runtime";
    this.rmiURL = "rmi://" + Config.getDNS(nodeId) + "/" + rmiServiceName;
  }


      
//-----------------------------------------------------------------------
// Accessor Methods
//-----------------------------------------------------------------------

  public NodeId getNodeId(){
    return nodeId;
  }

  public int getMaxSubRetries(){
    return maxSubRetries;
  }

  public int getMaxDemandReadRetries(){
    return maxDRRetries;
  }
  
  public long getSubTimeout(){
    return subTimeout;
  }

  public long getDemandReadTimeout(){
    return drTimeout;
  }

  public int getBodyWorkers(){
    return bodyWorkers;
  }

  public int getInvalWorkers(){
    return invalWorkers;
  }

  public int getDemandReadWorkers(){
    return demandWorkers;
  }

  public int getInformWorkers(){
    return informWorkers;
  }

  public int getCommandWorkers(){
    return commandWorkers;
  }

  public int getP2ServerPort(){
    return p2serverPort;
  }

 public int getP2ClientPort(){
    return p2clientPort;
  }

  public String getRMIUrl(){
    return rmiURL;
  }

  public String getRMIServiceName(){
    return rmiServiceName;
  }


}
//---------------------------------------------------------------------------
/* $Log: P2ConfigEntry.java,v $
/* Revision 1.5  2007/03/16 23:57:35  nalini
/* p2serverinterface added
/*
/* Revision 1.4  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.3  2006/10/02 23:23:39  nalini
/* synchronization support added
/*
/* Revision 1.2  2006/06/13 03:49:19  nalini
/* RMI for P2 Runtime Implemented
/*
*/
//---------------------------------------------------------------------------
