#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <string>
#include <fstream>
#include <sys/wait.h>

#ifndef __NOP2__
#if HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "p2.h"
#include "tuple.h"
#include "plumber.h"
#include "val_str.h"

P2::DataflowHandle * dataflowPtr;

#endif

#define SOCKET_ERROR        -1
#define BUFFER_SIZE         300
#define QUEUE_SIZE          1000

char filename[255];
char hostname[255];
char olgPort[255];
int P2PORT;
int CLIENTPORT;




void handleMsg(char msg[]);
void installOverlog();
void startOverlog();
void watch(char*);
void insert(char*);

int startSocketServer() {
  int hSocket,hServerSocket;  /* handle to socket */
  struct sockaddr_in address; /* Internet socket address stuct */
  int nAddressSize=sizeof(struct sockaddr_in);
  char pBuffer[BUFFER_SIZE];
  int nHostPort = P2PORT;

  printf("Starting server\n");

  printf("Making socket\n");
  hServerSocket=socket(AF_INET,SOCK_STREAM,0);

  if(hServerSocket == SOCKET_ERROR){
    printf("\nCould not make a socket\n");
    return 0;
  }

  /* fill address struct */
  address.sin_addr.s_addr=INADDR_ANY;
  address.sin_port=htons(nHostPort);
  address.sin_family=AF_INET;

  int yes = 1;
  setsockopt(hServerSocket, SOL_SOCKET, SO_REUSEADDR, (char *) &yes, sizeof yes);
  printf("\nBinding to port %d\n",nHostPort);

  /* bind to a port */
  if(bind(hServerSocket,(struct sockaddr*)&address,sizeof(address)) 
     == SOCKET_ERROR){
    printf("\nCould not connect to host\n");
    return 0;
  }

  /*  get port number */
  getsockname( hServerSocket, (struct sockaddr *) &address,(socklen_t *)&nAddressSize);
  printf("opened socket as fd (%d) on port (%d) for stream i/o\n",hServerSocket, ntohs(address.sin_port) );

  fflush(stdout);

  /* establish listen queue */
  if(listen(hServerSocket,QUEUE_SIZE) == SOCKET_ERROR)
  {
    printf("\nCould not listen\n");
    return 0;
  }

    
  for(;;)
  {

    /*clean buffer */
    for(int i=0; i < BUFFER_SIZE; i++) pBuffer[i]='\0';

    
    printf("Waiting for connection\n");
    fflush(stdout);
    /* get the connected socket */
    hSocket=accept(hServerSocket,(struct sockaddr*)&address,(socklen_t *)&nAddressSize);

    /* read from socket into buffer */
    if(read(hSocket,pBuffer,BUFFER_SIZE) < 0) {
      fprintf(stderr, "error reading from socket"); 
      fflush(stderr);
    }
    
   
     handleMsg(pBuffer);

    /* close socket */
    if(close(hSocket) == SOCKET_ERROR)
    {
      printf("\nCould not close socket\n");
      return 0;
    }
  }
}

int sendToRemoteServer(char msg[]) {
  int hSocket;                 /* handle to socket */
  struct hostent* pHostInfo;   /* holds info about a machine */
  struct sockaddr_in address;  /* Internet socket address stuct */
  long nHostAddress;
  char strHostName[255] = "localhost";
  int nHostPort = CLIENTPORT ;
 
  
  /* make a socket */
  hSocket=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);

  if(hSocket == SOCKET_ERROR){
    printf("\nCould not make a socket\n");
    return 0;
  }

  /* get IP address from name */
  pHostInfo=gethostbyname(strHostName);
 
  /* copy address into long */
  memcpy(&nHostAddress,pHostInfo->h_addr,pHostInfo->h_length);

  /* fill address struct */
  address.sin_addr.s_addr=nHostAddress;
  address.sin_port=htons(nHostPort);
  address.sin_family=AF_INET;
  
  printf("\nConnecting to %s on port %d",strHostName,nHostPort);

  /* connect to host */
  if(connect(hSocket,(struct sockaddr*)&address,sizeof(address)) 
     == SOCKET_ERROR)
  {
    fprintf(stderr,"\nCould not connect to host\n");
    fflush(stderr);
    return 0;
  }
  
  /* write what we received back to the server */
  write(hSocket,msg, strlen(msg));
  

  /* close socket */                       
  if(close(hSocket) == SOCKET_ERROR)
  {
    fprintf(stderr,"\nCould not close socket\n");
    fflush(stderr);
    return 0;
  }

  return 1;
}

int main(int argc, char*argv[]) {

   if(argc < 5) {
     fprintf(stderr, "Error: Usage: P2Server <P2_Port> <Client_PORT> <olgFilename> <olghostname> <olgPort>\n");
     exit(1);
   }

   printf("Starting P2Server \n");
   fflush(stdout);

  P2PORT = atoi(argv[1]);
  CLIENTPORT = atoi(argv[2]);
  strncpy(filename, argv[3], 255);
  strncpy(hostname,argv[4], 255);
  strncpy(olgPort,argv[5], 255);
  

  startSocketServer();
 
  return 1;

}


void handleMsg(char msg[]) {
  char value[255] ;

  if (msg[0] == '1') {
    strcpy(filename, msg+1);
    printf("\nReceived filename %s\n", filename);

  }
  else if (msg[0] == '2') {
    strcpy(hostname, msg+1);
    printf("\nReceived hostname %s\n", hostname);
  }
  else if (msg[0] == '3') {
    strcpy(olgPort, msg+1);
    printf("\nReceived port %s\n", olgPort);
  }
  else if (msg[0] == '4') {
    strcpy(value, msg+1);
    printf("\nReceived install\n ");
    installOverlog();
  }
  else if (msg[0] == '5') {
    strcpy(value, msg+1);
    printf("\nReceived watch %s", value);
    watch(value);
  }
  else if (msg[0] == '6') {
    printf("\nReceived start\n ");
    startOverlog();
  }
  else if (msg[0] == '7') {
    strcpy(value, msg+1);
    printf("\nReceived insert %s\n ", value);
    insert(value);
  }
  else {
    printf("\nUnknown message %s\n", msg);
  }
}




void installOverlog() {
#ifdef __NOP2__
  std::cout<<"P2 is not supported" << std::endl;
#else
  std::cout << "Filename: "<< filename <<std::endl;
  std::cout << "Hostname: "<< hostname <<std::endl;
  std::cout << "Port: "<< olgPort <<std::endl;

  std::vector< std::string > definitions;
  string program = P2::preprocessReadOverLogProgram(filename, 
                                                    filename,
                                                    definitions);
  
  std::ostringstream myAddressBuf;
  myAddressBuf <<  hostname << ":" << olgPort;
  std::string myAddress = myAddressBuf.str();
  
  P2::DataflowHandle dataflow =
    P2::createDataflow("overlog",
                       myAddress,
                       atoi(olgPort),
                       filename,
                       program, 
                       false,
                       false,
                       false);

  dataflowPtr = new P2::DataflowHandle(dataflow);

#endif
}



#ifndef __NOP2__
void rcvdTuple(P2::DataflowHandle dataflow, TuplePtr tp){
 std::string tpCStr = tp->toString();
 const char* cStr = tpCStr.c_str(); 
 printf("Received Tuple %s\n", cStr);
 sendToRemoteServer((char *)cStr);
}



void* p2_run_routine(void *args) {
  std::cout <<"running P2" << std::endl;
  try {
    P2::run();
  } catch (Element::Exception e) {
    TELL_ERROR << "Caught an Element exception '"
               << e.toString()
               << "'\n";
  }
  return NULL;
}
#endif

void watch(char* tupleName) {
#ifndef __NOP2__
   std::cout<< "call to watch : "<< tupleName << std::endl;
  P2::subscribe(*dataflowPtr, tupleName, boost::bind(&rcvdTuple,*dataflowPtr, _1));
#endif
}


void insert(char* tuple){
#ifndef __NOP2__
  printf("Trying to insert %s\n", tuple);
  TuplePtr tp = Tuple::mk();
  
  char* str = tuple + 1; //getting rid of the first <
  char* item;
  
  item = strtok(str, ",>");
  while (item != NULL) {
    printf("%s\n",item);
    tp->append(Val_Str::mk(item));
    item = strtok(NULL, ",>");
  }

  tp->freeze();

  P2::injectTuple(*dataflowPtr, tp, &P2::nullCallback);
  
  printf("finished inserting\n");
#endif
}


void startOverlog() {
#ifndef __NOP2__
  pthread_t p2_run_helper;
  // int status;
  pthread_create(&p2_run_helper, NULL, p2_run_routine, NULL);
#endif 
}
