//---------------------------------------------------------------------------
/* PadreNode
 *
 * Initialized practi node and sets up PRACTI and safety and liveness policy
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;
import java.util.*;

public class PadreNode {
  static boolean dbg = false;
  final protected P2Runtime runtime;
  final protected LocalInterface li;
  final protected Policy livenessPolicy;
  final protected SafetyPolicyModule safetyModule;
  final protected SafetyLivenessBridge slBridge;

 

//---------------------------------------------------------------------------
//  Constructor -- 
//---------------------------------------------------------------------------

  public PadreNode(String configPath, 
                   String p2ConfigPath,
                   NodeId nodeId,
                   boolean cleanDb,
                   boolean noSyncLog,
                   SafetyPolicyModule safetyModule_, 
                   Policy livenessPolicy_){

   Env.dprintln(dbg, "creating PadreNode");
   Config.readConfig(configPath);
   P2Config.readConfig(p2ConfigPath);
   safetyModule = safetyModule_;
   livenessPolicy = livenessPolicy_;
   
   runtime = new P2Runtime(nodeId, cleanDb, livenessPolicy, noSyncLog);
   livenessPolicy.setRuntime(runtime);
   li = new LocalInterface(runtime.getController(), runtime.getCore());

   slBridge = new SafetyLivenessBridge(livenessPolicy);
   safetyModule.setLocalInterface(li);
   safetyModule.setSafetyLivenessBridge(slBridge);

 
   Env.dprintln(dbg, "created PadreNode done");
 }



//---------------------------------------------------------------------------
// Starts Practi and Policy
//---------------------------------------------------------------------------
 
  public void start()throws Exception {
    Env.dprintln(dbg, "starting PadreNode");
    runtime.start();

    try{
      wait(100);
    }catch(Exception e) {}

    livenessPolicy.start();
    Env.dprintln(dbg, "PadreNode started");
  }


//---------------------------------------------------------------------------
// if noPolicy=true only starts practi.
//---------------------------------------------------------------------------
 
  public void start(boolean noPolicy)throws Exception {
    Env.dprintln(dbg, "starting PadreNode");
    runtime.start();
    try{
      wait(100);
    }catch(Exception e) {}

    if(!noPolicy) {
      livenessPolicy.start();
    }
    Env.dprintln(dbg, "PadreNode started");
  }


//---------------------------------------------------------------------------
// shuts down practi and policy
//---------------------------------------------------------------------------
 
  public void shutdown()throws Exception {
    Env.dprintln(dbg, "shutting down PadreNode");
    runtime.shutdown();
    livenessPolicy.shutdown();
    Env.dprintln(dbg, "PadreNode shutdown");
  }

 

//---------------------------------------------------------------------------
// Get method for runtime
//---------------------------------------------------------------------------

  public P2Runtime getP2Runtime(){
    return runtime;
  }

//--------------------------------------------------------------------------
// Get method for OverlogPolicy
//--------------------------------------------------------------------------
  public Policy getPolicy(){
    return livenessPolicy;
  }

//--------------------------------------------------------------------------
// Get method for SafetyModule
//--------------------------------------------------------------------------
  public SafetyPolicyModule getSafetyModule(){
    return safetyModule;
  }


//--------------------------------------------------------------------------
// Main - just starts of a padre node with a causal wrapper and null policy
//--------------------------------------------------------------------------
 
  public static void main(String[] args){
    if (args.length < 3) {
      System.out.println("Usage: PadreNode configPath p2ConfigPath nodeId");
      System.exit(0);
    }

    String configPath = args[0];
    String p2configPath = args[1];
    NodeId nodeId = new NodeId((new Long(args[2])).longValue());
    
    PadreNode node = new PadreNode(configPath, p2configPath, nodeId, true, false, 
                                   new CausalSafetyModule(), 
                                   new NullPolicy());
  }
 
}


//---------------------------------------------------------------------------
/* $Log: PadreNode.java,v $
/* Revision 1.1  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
*/
//---------------------------------------------------------------------------