//---------------------------------------------------------------------------
/* PendingBodySubscriptionQueue.java
 * 
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PendingBodySubscriptionQueue extends PendingSubscriptionQueue {
  
 
  //-------------------------------------------------------------------------
  // Constructor
  //-------------------------------------------------------------------------
  public PendingBodySubscriptionQueue() {
    super();
  }
  
  public void
  add(NodeId senderNode, NodeId receiverNode, SubscriptionSet ss){
    add(new BodySubscription(senderNode, receiverNode, ss));
  }

  public BodySubscription
  find(NodeId senderNode, NodeId receiverNode, SubscriptionSet ss){
    return (BodySubscription)find(new BodySubscription(senderNode, receiverNode, ss));
  }


  public BodySubscription
  remove(NodeId senderNode, NodeId receiverNode, SubscriptionSet ss){
    return (BodySubscription)remove(new BodySubscription(senderNode, receiverNode, ss));
  }

}

//---------------------------------------------------------------------------
/* $Log: PendingBodySubscriptionQueue.java,v $
/* Revision 1.7  2007/03/06 23:57:09  nalini
/* changed code so that retries only occur when rmi error occur
/*
/* Revision 1.6  2007/03/06 21:26:03  nalini
/* added verbose flags so as to print out rmi exceptions
/*
/* Revision 1.5  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/* 
*/
//---------------------------------------------------------------------------
