//---------------------------------------------------------------------------
/* PendingBodySubscriptionWorkerThread.java
 * 
 * gets pending subscriptions from the queue and reissues command
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PendingBodySubscriptionWorkerThread extends Thread{
    
  //
  // We don't really need rmiClient.  But it is added here to make the interface
  // consistent with PendingUpdateSubscriptionWorkerThread
  //

  private RMIClient rmiClient; 
  private Status status;
  private NodeId myNodeId;
  private P2Runtime runtime;
  private Core core;
  private boolean verbose = P2Runtime.verboseBodySub;

  public PendingBodySubscriptionWorkerThread(RMIClient rmiClient, Status status, 
					     NodeId myNodeId,
					     P2Runtime runtime,
                                             Core core){
    this.rmiClient = rmiClient;
    this.status = status;
    this.myNodeId = myNodeId;
    this.runtime = runtime;
    this.core = core;
  }

  //-------------------------------------------------------------------------
  //  gets the next pending subscription from the queue and adds it again
  //-------------------------------------------------------------------------
  
  public void 
  run(){
    
    long maxRetries = P2Config.getMaxSubRetries(myNodeId);

    PendingBodySubscriptionQueue pBodyQueue = 
      status.getPendingBodySubscriptionQueue();
    
    while(true){
      //
      //  update the timeout and add it back into the pending queue
      //
      Subscription s = pBodyQueue.getNextAndUpdateTimeout(maxRetries);
      
      if(s.getNumTries() <= maxRetries){
        issueCommand(s);
      }
      else{
	if(verbose){
	  Env.dprintln(verbose, "PendingBodySubscriptionWorkerThread :: reached max retries for " + s);
	}
        pBodyQueue.remove(s);
	runtime.informSubscribeBodyFailedMaxRetries(s.getSenderNode(), 
                                                    s.getSS());
      }
    }
  }

 //-------------------------------------------------------------------------
  //  method which issues PRACTI command to establish subscription 
  //-------------------------------------------------------------------------
  
  void issueCommand(Subscription s){
    try{
      VV startVV = core.getISStatusMinLpVV(s.getSS());
      rmiClient.subscribeBody(s.getSenderNode(), s.getReceiverNode(), 
                              s.getSS(), startVV);
    }catch(Exception e){
      //
      // No action needed. Retry will happen when timer
      // goes off. If maxRetries exceeded, that is when
      // this "event" gets "escalated" for attention/
      // Stash this exception in s to facilitate debugging.
      //
      s.setMostRecentException(e);
      if(verbose){
	Env.dprintln(verbose, "PendingBodySubscriptionWorkerThread: Exception when handling: " + s);
	Env.dprintln(verbose, e.toString());
      }
    }
  }
    
}

//---------------------------------------------------------------------------
/* $Log: PendingBodySubscriptionWorkerThread.java,v $
/* Revision 1.10  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.9  2007/03/09 21:46:09  nalini
/* added 2 events: informAddInvalSubscriptionFailed & informAddBodySubscriptionFailed
/*
/* Revision 1.8  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.6  2007/03/06 23:57:09  nalini
/* changed code so that retries only occur when rmi error occur
/*
/* Revision 1.5  2006/10/31 21:43:33  nalini
/* added control msgs to body streams
/*
/* Revision 1.4  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/*
*/
//---------------------------------------------------------------------------
