//---------------------------------------------------------------------------
/* PendingInvalSubscriptionQueue.java
 * 
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PendingInvalSubscriptionQueue extends PendingSubscriptionQueue {
    
 
  //-------------------------------------------------------------------------
  // Constructor
  //-------------------------------------------------------------------------
  public PendingInvalSubscriptionQueue() {
    super();
  }

  public void
  add(NodeId senderNode, NodeId receiverNode, SubscriptionSet ss, boolean catchupWithCP){
    add(new InvalSubscription(senderNode, receiverNode, ss, catchupWithCP));
  }

  public InvalSubscription
  find(NodeId senderNode, NodeId receiverNode, SubscriptionSet ss){
    return (InvalSubscription)find(new InvalSubscription(senderNode, receiverNode, ss));
  }


  public InvalSubscription
  remove(NodeId senderNode, NodeId receiverNode, SubscriptionSet ss){
    return (InvalSubscription)remove(new InvalSubscription(senderNode, receiverNode, ss));
  }


    
}

//---------------------------------------------------------------------------
/* $Log: PendingInvalSubscriptionQueue.java,v $
/* Revision 1.8  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.7  2007/03/06 23:57:09  nalini
/* changed code so that retries only occur when rmi error occur
/*
/* Revision 1.6  2007/03/06 21:26:03  nalini
/* added verbose flags so as to print out rmi exceptions
/*
/* Revision 1.5  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/*
*/
//---------------------------------------------------------------------------
