//---------------------------------------------------------------------------
/* PendingInvalSubscriptionWorkerThread.java
 * 
 * gets pending subscriptions from the queue and reissues command
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PendingInvalSubscriptionWorkerThread extends Thread{
        
  //
  // We don't really need rmiClient.  But it is added here to make the interface
  // consistent with PendingUpdateSubscriptionWorkerThread
  //

  private RMIClient rmiClient; 
  private Status status;
  private NodeId myNodeId;
  private P2Runtime runtime;
  private Core core;
  private static final boolean verbose = P2Runtime.verboseInvalSub;
  private static final boolean dbg = false;
  public PendingInvalSubscriptionWorkerThread(RMIClient rmiClient, Status status,
                                              NodeId myNodeId, 
					      P2Runtime runtime,
                                              Core core){
    this.rmiClient = rmiClient;
    this.status = status;
    this.myNodeId = myNodeId;
    this.runtime = runtime;
    this.core = core;
  }

  //-------------------------------------------------------------------------
  //  gets the next pending subscription from the queue and adds it again
  //-------------------------------------------------------------------------
  
  public void 
  run(){
    
    long maxRetries = P2Config.getMaxSubRetries(myNodeId);

    PendingInvalSubscriptionQueue pInvalQueue = 
      status.getPendingInvalSubscriptionQueue();
    
    while(true){
      if(dbg){
	Env.dprintln(dbg, "PendingInvalSubscriptionWorkerThread: waiting to get subscription");
      }
      Subscription s = pInvalQueue.getNextAndUpdateTimeout(maxRetries);
      
      if(dbg){
	Env.dprintln(dbg, "PendingInvalSubscriptionWorkerThread: gotsubscription = " + s);
      }    

      if(s.getNumTries() <= maxRetries){
        issueCommand(s);
        s.incNumTries();
	if(dbg){
	  Env.dprintln(dbg, "PendingInvalSubcripitonWorkerThread: FinishedIssuing command");
	}
	Exception e = s.getMostRecentException();
        if(e == null) {
          pInvalQueue.remove(s);
          runtime.informSubscribeInvalSucceeded(s.getSenderNode(), s.getSS());
        }
        else{
	  if(dbg){
	    // Some exception occured, need to retry again
	    Env.dprintln(dbg, "PendingInvalSubsrciptionThread: got exception adding to queue again " +
			 e.toString());
	  }
          s.setMostRecentException(null);

        }
  
      }  else {
	if(dbg||verbose){
	  Env.dprintln(dbg || verbose, "PendingInvalSubcripitonWorkerThread: max retries reached for " + s);
        }
	  pInvalQueue.remove(s);
	runtime.informSubscribeInvalFailedMaxRetries(s.getSenderNode(),s.getSS());  
      }
    }
  }

  //-------------------------------------------------------------------------
  //  method which issues PRACTI command to establish subscription 
  //-------------------------------------------------------------------------
  
  void issueCommand(Subscription s){
    try{
      AcceptVV startVV = core.getISStatusMinLpVV(s.getSS());
  
      rmiClient.subscribeInval(s.getSenderNode(), s.getReceiverNode(), 
                               s.getSS(), startVV, 
                               ((InvalSubscription) s).getCatchupType());
    }catch(Exception e){
      //
      // No action needed. Retry will happen when timer
      // goes off. If maxRetries exceeded, that is when
      // this "event" gets "escalated" for attention/
      // Stash this exception in s to facilitate debugging.
      //
      s.setMostRecentException(e);
      if(verbose){
	Env.dprintln(verbose, "PendingInvalSubscriptionWorkerThread: Exception when handling: " + s);
	Env.dprintln(verbose, e.toString());
      }
    }
  }

}

//---------------------------------------------------------------------------
/* $Log: PendingInvalSubscriptionWorkerThread.java,v $
/* Revision 1.15  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.14  2007/06/04 21:41:00  zjiandan
/* expose stream catchup type CP|LOG option to rmiClient.subscribeInval().
/*
/* Revision 1.13  2007/04/12 17:09:32  zjiandan
/* fix across unit test mem leak.
/*
/* Revision 1.12  2007/04/02 22:10:02  nalini
/* junit fixes
/*
/* Revision 1.11  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.10  2007/03/09 21:46:09  nalini
/* added 2 events: informAddInvalSubscriptionFailed & informAddBodySubscriptionFailed
/*
/* Revision 1.9  2007/03/08 23:05:53  nalini
/* minor dbg changes
/*
/* Revision 1.8  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.6  2007/03/06 23:57:09  nalini
/* changed code so that retries only occur when rmi error occur
/*
*/
//---------------------------------------------------------------------------
