//---------------------------------------------------------------------------
/* PendingSubscriptionQueue.java
 * 
 * Implements a pending subscription queue
 * Keeps the pending subsriptions in timeout order 
 *
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------


public class PendingSubscriptionQueue {
  private TimeoutQueue tQueue;
  
  private boolean dbg = false;
  
  //-------------------------------------------------------------------------
  // Constructor
  //-------------------------------------------------------------------------
  public PendingSubscriptionQueue(){
    this.tQueue = new TimeoutQueue();
  }

  //-------------------------------------------------------------------------
  //  adds it to the queue
  //-------------------------------------------------------------------------
  
  public void
  add(Subscription s){
    long timeoutValue = 0;
    add(s, timeoutValue);
  }

  public void
  add(Subscription s, long timeoutValue){
    tQueue.insert(timeoutValue, s);
    if(dbg){
      Env.dprintln(dbg, "PendingSubscriptionQueue :: added  " + s +
		   " with timeout=" + timeoutValue);
    }
  }


  //-------------------------------------------------------------------------
  // Removes subscription from the queue and returns the removed object
  //-------------------------------------------------------------------------
  public Subscription
  remove(Subscription s){
    if(dbg){
      Env.dprintln(dbg, "PendingSubscriptionQueue :: remove " + s + " called");  
    } 
    return (Subscription)tQueue.remove(s);
  }

  //-------------------------------------------------------------------------
  // Finds teh subscription in the queue
  //-------------------------------------------------------------------------
  public Subscription
  find(Subscription s){
    if(dbg){
      Env.dprintln(dbg, "PendingSubscriptionQueue :: find " + s + " called"); 
    }  
    return (Subscription)tQueue.find(s);
  }

  //-------------------------------------------------------------------------
  // Returns the next pending subscription 
  // Blocks until the timeout has reached
  //-------------------------------------------------------------------------
  public Subscription
  getNext(){
    return (Subscription)tQueue.getNext();
  }

  //-------------------------------------------------------------------------
  // Returns the next pending subscription 
  // adds it back into the queue with
  // the timeout updated and the numTries updated if 
  // maxTries hasn't been reached
  //-------------------------------------------------------------------------
  public synchronized Subscription
  getNextAndUpdateTimeout(long maxRetries){
    if(dbg){
      Env.dprintln(dbg, "PendingSubscriptionQueue :: getNextAndUpdateTimeout called");
    }
    Subscription s = (Subscription)tQueue.getNext();
    Subscription ret = (Subscription) s.clone();
    if(s.getNumTries() <= maxRetries){
      s.incNumTries();
      add(s, P2Config.getSubTimeout(s.getSenderNode()));
    }
    if(dbg){
      Env.dprintln(dbg, "PendingSubscriptionQueue :: getNextAndUpdateTimeout returning " + ret);
    }
    return ret;
  }

  public String toString() {
    assert false; //add by zjd -- tmp to dbg performance
    return tQueue.toString();
  }

}


//---------------------------------------------------------------------------
/* $Log: PendingSubscriptionQueue.java,v $
/* Revision 1.4  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.3  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.2  2007/03/06 23:57:09  nalini
/* changed code so that retries only occur when rmi error occur
/*
*/
//---------------------------------------------------------------------------
