//---------------------------------------------------------------------------
/* Policy.java
 * 
 *  Simplifed interface for policy writers
 *
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------


public abstract class Policy {

  protected P2Runtime runtime;

//---------------------------------------------------------------------------
// setting the runtime to interact with
//---------------------------------------------------------------------------
  public void setRuntime(P2Runtime runtime_){
    runtime = runtime_;
  }

//---------------------------------------------------------------------------
// starts the policy layer
//---------------------------------------------------------------------------
  public abstract void start();


//---------------------------------------------------------------------------
// shuts down the policy layer
//---------------------------------------------------------------------------
  public abstract void shutdown();

//---------------------------------------------------------------------------
// interface to interact with safety module
//---------------------------------------------------------------------------

  // sendMsg: called by safety to send a msg to liveness policy
  public abstract void receiveMsg(String[] msg);

//---------------------------------------------------------------------------
// information of practi events
//---------------------------------------------------------------------------


  // Note: we may get muliple informLocalReadInvalid events for the
  // same read. If we already have issued a demand read for this
  // objId/offset, then we may want to rely on underlying retry
  // logic rather than resend request.
  public abstract void informLocalReadInvalid(ObjId objId, long offset, long length,
				     AcceptStamp inval);

  // Note: we may get muliple informLocalReadImprecise events for the
  // same read. If we already have issued connection request,
  // then we may want to rely on underlying retry logic rather 
  // than resend request.
  public abstract void informLocalReadImprecise(ObjId objId, long offset, long length);

  public abstract void informLocalWrite(ObjId objId, long offset, long length, AcceptStamp as,
                               boolean isBound, boolean isEmbargoed);

  public abstract void informLocalDelete(ObjId objId);

  public abstract void informReceiveInval(NodeId senderNodeId, ObjId objId, long offset, long length,
                                 AcceptStamp as, boolean isBound, boolean isEmbargoed);


  public abstract void informDemandReadSuccess(NodeId senderNodeId, ObjId objId, 
                                      long offset, long length,
				      AcceptStamp as);
  public abstract void informDemandReadFailedMiss(NodeId senderNodeId, ObjId objId, 
                                         long offset, long length,
					 AcceptStamp as);
 
  public abstract void informDemandReadFailedMaxRetries(NodeId senderNodeId, ObjId objId, 
                                               long offset, long length,
					       AcceptStamp as);

  public abstract void recvSyncReply(NodeId senderNodeId, AcceptStamp acceptStamp);


//---------------------------------------------------------------------------
// Subscription add events
//---------------------------------------------------------------------------

  public abstract void informAddedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);

  public abstract void informAttachedInvalSubscription(NodeId senderNodeId, 
                                              NodeId receiverNodeId, 
                                              SubscriptionSet ss);

  public abstract void informAddedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);

  public abstract void informAddedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);

  public abstract void informAddedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);

//---------------------------------------------------------------------------
// Subscription removed events
//---------------------------------------------------------------------------
  

  //Note:  This is triggered when
  //       - SS is removed from a connection
  //       - inval connection dies
  public abstract void informRemovedInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);
  //Note:  This is triggered when
  //       - body connection dies
  public abstract void informRemovedBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);

  public abstract void informRemovedOutgoingInvalSubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);

  public abstract void informRemovedOutgoingBodySubscription(NodeId senderNodeId, 
                                            NodeId receiverNodeId, 
                                            SubscriptionSet ss);
  
//---------------------------------------------------------------------------
// Subscription failed
//---------------------------------------------------------------------------
  

  //Note:  This is triggered when
  //       - can't establish an inval subscription
  public abstract void informAddInvalSubscriptionFailed(NodeId senderNodeId, 
                                               NodeId receiverNodeId, 
                                               SubscriptionSet ss);
  //Note:  This is triggered when
  //       - can't establish a body connection
  public abstract void informAddBodySubscriptionFailed(NodeId senderNodeId, 
                                              NodeId receiverNodeId, 
                                              SubscriptionSet ss);

}
//---------------------------------------------------------------------------
/* $Log: Policy.java,v $
/* Revision 1.11  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
/* Revision 1.10  2007/03/09 21:46:09  nalini
/* added 2 events: informAddInvalSubscriptionFailed & informAddBodySubscriptionFailed
/*
/* Revision 1.9  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.8  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.7  2006/09/26 05:34:09  nalini
/* added sync interface to policy and runtime
/*
/* Revision 1.6  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/*
*/
//---------------------------------------------------------------------------
