//---------------------------------------------------------------------------
/* pollItem 
 * 
 * keeps track of objId and the polltimeout for watched files
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PollItem {
  ObjId objId;
  long pollTime;

  //-------------------------------------------------------------------------
  // Constructor
  //-------------------------------------------------------------------------  
  public PollItem(ObjId objId, long pollTime){
    this.objId = objId;
    this.pollTime = pollTime;
  }

  //-------------------------------------------------------------------------
  // get methods
  //-------------------------------------------------------------------------  
  public ObjId getObjId(){
    return objId;
  }

  public long getPollTime() {
    return pollTime;
  }

  //-------------------------------------------------------------------------
  // toString
  //-------------------------------------------------------------------------  
  public String toString(){
    return objId + ":" + pollTime;
  }

  //-------------------------------------------------------------------------
  // equals method
  // 
  // Note: we only compare objId, and not pollTime
  //-------------------------------------------------------------------------  
  public boolean equals(Object o){
    if (this==o) {
      return true;
    }

    if(!(o instanceof PollItem)){
      return false;
    }

    PollItem other = (PollItem) o;
    if(this.objId.equals(other.objId)){
      return true;
    }
    return false;
  }
}

//---------------------------------------------------------------------------
/* $Log: PollItem.java,v $
/* Revision 1.1  2007/07/11 20:25:53  nalini
/* persistent tuple support added
/*
*/
//---------------------------------------------------------------------------

