//---------------------------------------------------------------------------
/* PushUpdateCmd.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------

public class PushUpdateCmd extends PractiCommand {
 
  private ObjId objId;
  private long offset;
  private long length;
  private NodeId senderNodeId;
  private NodeId targetNodeId;

//--------------------------------------------------------------------------
// constructor
//--------------------------------------------------------------------------
  public PushUpdateCmd(ObjId objId,
                       long offset,
                       long length,
                       NodeId senderNodeId,
                       NodeId targetNodeId) {
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.senderNodeId = senderNodeId;
    this.targetNodeId = targetNodeId;

  }
 
//--------------------------------------------------------------------------
// doCommand Method
//--------------------------------------------------------------------------
  public void  doCommand(RMIClient rmiClient, Core core) throws Exception {
    long requestId = 0; // not sure what to set it up as
    rmiClient.issueDemandRead(objId,
                              offset, 
                              length,
                              requestId,
                              senderNodeId,
                              targetNodeId,
                              Config.getDNS(targetNodeId),
                              Config.getPortBody(targetNodeId),
			      new AcceptStamp(-1, new NodeId(-1)));
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "PushUpdateCmd :" + objId + ", " + offset + ", " + length + 
      ", " + senderNodeId + ", " + targetNodeId; 
  }
}

//---------------------------------------------------------------------------
/* $Log: PushUpdateCmd.java,v $
/* Revision 1.3  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.2  2006/10/13 20:49:31  nalini
/* minor fixes
/*
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
