//---------------------------------------------------------------------------
/* PushUpdateHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class PushUpdateHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public PushUpdateHandler(P2Runtime runtime){
    super("pushUpdate");
    this.runtime = runtime;
  }

 
  public void handleTuple(Tuple tp) {
    //Env.dprintln(dbg, "handlePushUpdate: "+ tp);
    // <demandRead, myOverlogId, targetNode, objId, offset, length>
    NodeId targetNode = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));

    ObjId objId;
    if(OverlogPolicy.P2VersionHasStringProblem){
      objId = new ObjId(tp.getItem(3).replaceAll("-", "/"));  
    }else {
      objId = new ObjId(tp.getItem(3));  
    }

    long offset = new Long(tp.getItem(4)).longValue();
    long length = new Long(tp.getItem(5)).longValue();

    runtime.pushUpdate(targetNode, objId, offset, length);
  }
}

//---------------------------------------------------------------------------
/* $Log: PushUpdateHandler.java,v $
/* Revision 1.3  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.2  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------