//---------------------------------------------------------------------------
/* RemoveInvalSubscripitonHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class RemoveInvalSubscriptionHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public RemoveInvalSubscriptionHandler(P2Runtime runtime){
    super("removeInvalSubscription");
    this.runtime = runtime;
  }

 
  public void handleTuple(Tuple tp) {
    //Env.dprintln(dbg, "handleRemoveInvalSubscription: "+ tp);
    // <removeInvalSubscription, myOverlogId, senderNode, ss>
    NodeId senderNode = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));

    SubscriptionSet ss;
    if(OverlogPolicy.P2VersionHasStringProblem){
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3).replaceAll("-", "/"));  
    }else {
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3));
    }
    
    //Env.dprintln(dbg, "ss =" + ss);
    runtime.removeInvalSubscription(senderNode, ss);
  }
}

//---------------------------------------------------------------------------
/* $Log: RemoveInvalSubscriptionHandler.java,v $
/* Revision 1.4  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.3  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.2  2007/03/08 23:05:53  nalini
/* minor dbg changes
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------
