//---------------------------------------------------------------------------
/* RemoveOutgoingInvalSubscripitonHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class RemoveOutgoingInvalSubscriptionHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public RemoveOutgoingInvalSubscriptionHandler(P2Runtime runtime){
    super("removeOutgoingInvalSubscription");
    this.runtime = runtime;
  }

 
  public void handleTuple(Tuple tp) {
    //Env.dprintln(dbg, "handleRemoveOutgoingInvalSubscription: "+ tp);
    // <removeOutgoingInvalSubscription, myOverlogId, targetNode, ss>
    NodeId targetNode = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));

    SubscriptionSet ss;
    if(OverlogPolicy.P2VersionHasStringProblem){
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3).replaceAll("-", "/"));  
    }else {
      ss = SubscriptionSet.makeSubscriptionSet(tp.getItem(3));
    }

     
    runtime.removeOutgoingInvalSubscription(targetNode, ss);
  }
}

//---------------------------------------------------------------------------
/* $Log: RemoveOutgoingInvalSubscriptionHandler.java,v $
/* Revision 1.4  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.3  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.2  2007/01/12 19:12:05  nalini
/* minor updates
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------
