//---------------------------------------------------------------------------
/* RemoveSubscribeBodyCmd.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------

public class RemoveSubscribeBodyCmd extends PractiCommand {
 
  private NodeId senderNodeId;
  private NodeId targetNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// constructor
//--------------------------------------------------------------------------
  public RemoveSubscribeBodyCmd(NodeId senderNodeId,
                                NodeId targetNodeId,
                                SubscriptionSet ss) {
    this.senderNodeId = senderNodeId;
    this.targetNodeId = targetNodeId;
    this.ss = ss;
  }
 
//--------------------------------------------------------------------------
// doCommand Method
//--------------------------------------------------------------------------
  public void  doCommand(RMIClient rmiClient, Core core) throws Exception {
    rmiClient.removeSubscribeBody(senderNodeId, targetNodeId, ss);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "RemoveSubscribeBodyCmd :" + senderNodeId + ", " + targetNodeId + 
      ", " + ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: RemoveSubscribeBodyCmd.java,v $
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
