//---------------------------------------------------------------------------
/* RemoveSubscribeInvalCmd.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------

public class RemoveSubscribeInvalCmd extends PractiCommand {
 
  private NodeId senderNodeId;
  private NodeId targetNodeId;
  private SubscriptionSet ss;

//--------------------------------------------------------------------------
// constructor
//--------------------------------------------------------------------------
  public RemoveSubscribeInvalCmd(NodeId senderNodeId,
                                NodeId targetNodeId,
                                SubscriptionSet ss) {
    this.senderNodeId = senderNodeId;
    this.targetNodeId = targetNodeId;
    this.ss = ss;
  }
 
//--------------------------------------------------------------------------
// doCommand Method
//--------------------------------------------------------------------------
  public void doCommand(RMIClient rmiClient, Core core) throws Exception {
    rmiClient.removeSubscribeInval(senderNodeId, targetNodeId, ss);
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "RemoveSubscribeInvalCmd :" +  senderNodeId + ", " + targetNodeId + 
      ", " + ss;
  }
}

//---------------------------------------------------------------------------
/* $Log: RemoveSubscribeInvalCmd.java,v $
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
