//---------------------------------------------------------------------------
/* RequestSyncCmd.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------

public class RequestSyncCmd extends PractiCommand {
 
  private NodeId senderNodeId;
  private NodeId receiverNodeId;
  private AcceptStamp as;
  private AcceptVV aVV;
  private boolean dbg = false;

//--------------------------------------------------------------------------
// constructor
//--------------------------------------------------------------------------
  public RequestSyncCmd(NodeId senderNodeId,
                        NodeId receiverNodeId,
                        AcceptStamp as) {
    this.senderNodeId = senderNodeId;
    this.receiverNodeId = receiverNodeId;
    this.as = as;
    this.aVV = null;
  }
 
//--------------------------------------------------------------------------
// constructor
//--------------------------------------------------------------------------
  public RequestSyncCmd(NodeId senderNodeId,
                        NodeId receiverNodeId,
                        AcceptVV aVV) {
    this.senderNodeId = senderNodeId;
    this.receiverNodeId = receiverNodeId;
    this.as = null;
    this.aVV = aVV;
  }
//--------------------------------------------------------------------------
// doCommand Method
//--------------------------------------------------------------------------
  public void doCommand(RMIClient rmiClient, Core core) throws Exception {
    //Env.dprintln(dbg, "Executing cmd: " + this);
    if(as != null){
      rmiClient.requestSync(senderNodeId, receiverNodeId, as);
    } else {
      rmiClient.requestSync(senderNodeId, receiverNodeId, aVV);
    }
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    if (as!=null) {
      return "RequestSyncCmd :" + senderNodeId + ", " + receiverNodeId + 
        ", " + as;
    }
    return "RequestSyncCmd :" + senderNodeId + ", " + receiverNodeId + 
        ", " + aVV;
      
  }
}

//---------------------------------------------------------------------------
/* $Log: RequestSyncCmd.java,v $
/* Revision 1.5  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.4  2007/01/06 01:04:35  nalini
/* minor bug fixes for requestSync(VV)
/*
/* Revision 1.3  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.2  2006/10/10 19:46:00  nalini
/* minor bug fix
/*
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
