//---------------------------------------------------------------------------
/* RequestSyncHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class RequestSyncHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public RequestSyncHandler(P2Runtime runtime){
    super("requestSync");
    this.runtime = runtime;
  }
 
  public void handleTuple(Tuple tp) {
    //Env.dprintln(dbg, "handleRequestSync: " + tp);
    //<requestSync, myOverlogId, remoteOverlogId, ts, nodeId>
    NodeId remoteNodeId = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));
    long ts = new Long(tp.getItem(3)).longValue();
    NodeId nodeId = new NodeId(new Long(tp.getItem(4)).longValue());
    AcceptStamp as = new AcceptStamp(ts, nodeId);

    runtime.requestSync(remoteNodeId, as);
  }

}

//---------------------------------------------------------------------------
/* $Log: RequestSyncHandler.java,v $
/* Revision 1.4  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.3  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.2  2006/10/17 23:40:55  nalini
/* minor bug fixes and separated AS into individual components in overlog tuples
/*
/* Revision 1.1  2006/10/16 20:54:51  nalini
/* P2 tuple handler support added
/*
*/
//---------------------------------------------------------------------------