//---------------------------------------------------------------------------
/* RuntimeRMIClient.java
 *
 * RMI Client for Runtime Class so that Controllers can communicate
 * 
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.rmi.*;
import java.rmi.server.*;

public class RuntimeRMIClient {

  P2Runtime runtime;

  public RuntimeRMIClient(P2Runtime runtime_){
    this.runtime = runtime_;
  }  


//-----------------------------------------------------------------------
// Body Subscriptions
//-----------------------------------------------------------------------
  
  public void
  addBodySubscription(NodeId senderNode, NodeId targetNode, SubscriptionSet ss)
    throws RMINetworkException, RMIApplicationException { 
    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));
      
      runtimeRMIServer.addBodySubscription(senderNode, ss);

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
  }


  public void 
  removeBodySubscription(NodeId senderNode, NodeId targetNode, SubscriptionSet ss)
    throws RMINetworkException, RMIApplicationException { 
    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));

      runtimeRMIServer.removeBodySubscription(senderNode, ss);

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
  }



//-----------------------------------------------------------------------
// Inval Subscriptions
//-----------------------------------------------------------------------
  
  public void
  addInvalSubscription(NodeId senderNode, NodeId targetNode, SubscriptionSet ss,
                       boolean catchupWithCP)
    throws RMINetworkException, RMIApplicationException { 
    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));
      
      runtimeRMIServer.addInvalSubscription(senderNode, ss, catchupWithCP);

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
  }



  public void 
  removeInvalSubscription(NodeId senderNode, NodeId targetNode, SubscriptionSet ss)
    throws RMINetworkException, RMIApplicationException { 
    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));

      runtimeRMIServer.removeInvalSubscription(senderNode, ss);
    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
  }


  //---------------------------------------------------------------------------
  // Handling Demand Reads
  //---------------------------------------------------------------------------
   
  public void 
      demandRead(NodeId senderNode, NodeId targetNode, ObjId objId, long offset, long length,
		 AcceptStamp as)
    throws RMINetworkException, RMIApplicationException { 
    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));
      
      runtimeRMIServer.demandRead(senderNode, objId, offset, length, as);

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
  }


  //---------------------------------------------------------------------------
  // Requesting Sync
  //---------------------------------------------------------------------------
   
  public void 
  requestSync(NodeId remoteNodeId, NodeId targetNodeId, AcceptStamp acceptStamp)
    throws RMINetworkException, RMIApplicationException { 
    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNodeId));
      
      runtimeRMIServer.requestSync(remoteNodeId, acceptStamp);

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
  }
    

  public void 
  requestSync(NodeId remoteNodeId, NodeId targetNodeId, AcceptVV acceptVV)
    throws RMINetworkException, RMIApplicationException { 
    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNodeId));
      
      runtimeRMIServer.requestSync(remoteNodeId, acceptVV);

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
  }
    
  //---------------------------------------------------------------------------
  // Retreving the list of subscriptions
  //---------------------------------------------------------------------------
  
  public SubscriptionTable
  getEstablishedBodySubscriptions(NodeId targetNode)
    throws RMINetworkException, RMIApplicationException { 

    SubscriptionTable st = null;

    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));
      st = runtimeRMIServer.getEstablishedBodySubscriptions();

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
    return st;
  }



  public SubscriptionTable
  getEstablishedInvalSubscriptions(NodeId targetNode)
    throws RMINetworkException, RMIApplicationException { 

    SubscriptionTable st = null;

    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));

      st = runtimeRMIServer.getEstablishedInvalSubscriptions();

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }
    return st;

  }
 
  public SubscriptionTable
  getEstablishedOutgoingBodySubscriptions(NodeId targetNode)
    throws RMINetworkException, RMIApplicationException { 

    SubscriptionTable st = null;

    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));

      st = runtimeRMIServer.getEstablishedOutgoingBodySubscriptions();

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }

    return st;
  }

 

  public SubscriptionTable
  getEstablishedOutgoingInvalSubscriptions(NodeId targetNode)
    throws RMINetworkException, RMIApplicationException { 

    SubscriptionTable st = null;

    try {
      RuntimeRMIServer runtimeRMIServer = 
	(RuntimeRMIServer) Naming.lookup(P2Config.getRMIUrl(targetNode));

      st = runtimeRMIServer.getEstablishedOutgoingInvalSubscriptions();

    }catch(java.net.MalformedURLException e){
        e.printStackTrace();
        System.exit(-1);
      }catch(ConnectException a){
        throw new RMINetworkException(a);
      }catch(ConnectIOException b){
        throw new RMINetworkException(b);
      }catch(NotBoundException c){
        throw new RMINetworkException(c);
      }catch(UnknownHostException d){
        throw new RMINetworkException(d);
      }catch(RemoteException e){
        e.printStackTrace();
        throw new RMIApplicationException(e);
      }

    return st;
  }
 
}

//---------------------------------------------------------------------------
/* $Log: RuntimeRMIClient.java,v $
/* Revision 1.7  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.6  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.5  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.4  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.3  2006/09/26 05:34:09  nalini
/* added sync interface to policy and runtime
/*
/* Revision 1.2  2006/08/09 18:52:16  dahlin
/* Fixed Makefile to be portable to cygwin by fixing classpath definitions; fixed P2Runtime/Runtime v. java.lang.Runtime conflict by moving P2Runtime/Runtime to P2Runtime/P2Runtime
/*
/* Revision 1.1  2006/06/13 03:49:19  nalini
/* RMI for P2 Runtime Implemented
/*
 */
//---------------------------------------------------------------------------
