//---------------------------------------------------------------------------
/* RuntimeRMIServer.java
 *
 * RMI Server for Runtime Class so that Controllers can communicate
 * 
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.rmi.*;

public interface RuntimeRMIServer extends java.rmi.Remote {

//-----------------------------------------------------------------------
// Body Subscriptions
//-----------------------------------------------------------------------
  
  public void
  addBodySubscription(NodeId senderNode, SubscriptionSet ss)
    throws java.rmi.RemoteException;


  public void 
  removeBodySubscription(NodeId senderNode, SubscriptionSet ss)
    throws java.rmi.RemoteException;


//-----------------------------------------------------------------------
// Inval Subscriptions
//-----------------------------------------------------------------------
  
  public void
  addInvalSubscription(NodeId senderNode, SubscriptionSet ss, 
                       boolean catchupWithCP)
    throws java.rmi.RemoteException;


  public void 
  removeInvalSubscription(NodeId senderNode, SubscriptionSet ss)
    throws java.rmi.RemoteException;


  //---------------------------------------------------------------------------
  // Handling Demand Reads
  //---------------------------------------------------------------------------
   
  public void 
      demandRead(NodeId senderNode, ObjId objId, long offset, long length, AcceptStamp as)
    throws java.rmi.RemoteException;

  //---------------------------------------------------------------------------
  // Requesting Sync
  //---------------------------------------------------------------------------
   
  public void
  requestSync(NodeId remoteNodeId, AcceptStamp acceptStamp)
    throws java.rmi.RemoteException;

  public void
  requestSync(NodeId remoteNodeId, AcceptVV acceptVv)
    throws java.rmi.RemoteException;
    
  //---------------------------------------------------------------------------
  // Retreving the list of subscriptions
  //---------------------------------------------------------------------------
  
  public SubscriptionTable
  getEstablishedBodySubscriptions()
    throws java.rmi.RemoteException;


  public SubscriptionTable
  getEstablishedInvalSubscriptions()
    throws java.rmi.RemoteException;
 
  public SubscriptionTable
  getEstablishedOutgoingBodySubscriptions()
    throws java.rmi.RemoteException;
 

  public SubscriptionTable
  getEstablishedOutgoingInvalSubscriptions()
    throws java.rmi.RemoteException;
 
}

//---------------------------------------------------------------------------
/* $Log: RuntimeRMIServer.java,v $
/* Revision 1.6  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.5  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.4  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.3  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.2  2006/09/26 05:34:10  nalini
/* added sync interface to policy and runtime
/*
/* Revision 1.1  2006/06/13 03:49:19  nalini
/* RMI for P2 Runtime Implemented
/*
 */
//---------------------------------------------------------------------------
