//---------------------------------------------------------------------------
/* RuntimeRMIServerImpl.java
 *
 * RMI Server Implementation for Runtime Class so that Controllers can
 * communicate
 *
 * Note:
 *      rmic -d . RuntimeRMIServerImpl
 * will generate the skeleton and stub classes
 * 
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.rmi.*;
import java.rmi.server.*;

public class RuntimeRMIServerImpl extends UnicastRemoteObject 
                                  implements RuntimeRMIServer {

  P2Runtime runtime;
  boolean started;
  boolean dbg = true;

//-----------------------------------------------------------------------
// Constructor
//-----------------------------------------------------------------------
  
  public RuntimeRMIServerImpl(P2Runtime runtime_)
    throws java.rmi.RemoteException{
    this.runtime = runtime_;
    this.started = false;
  }


//-----------------------------------------------------------------------
// Start() - registers the server with the rmi registry
//-----------------------------------------------------------------------
  
  public void start(){

    try {
      if (!started){
	Naming.rebind(P2Config.getRMIServiceName(runtime.getMyNodeId()), this);
	started = true;
      }
    }catch(Exception e){
      e.printStackTrace();
      System.err.println("*****************\n"
                         + "RuntimeRMIServerImpl:start -- did you "
                         + "remember to run \'rmiregistry &\'?"
                         + "\nDid you remember to remake rmic "
                         + " after any changes?\n"
                         + "*****************");
      System.exit(-1);
    }

  }


//-----------------------------------------------------------------------
// Body Subscriptions
//-----------------------------------------------------------------------
  
  public void
  addBodySubscription(NodeId senderNode, SubscriptionSet ss)
    throws java.rmi.RemoteException{
    runtime.addBodySubscription(senderNode, ss);
  }

  public void 
  removeBodySubscription(NodeId senderNode, SubscriptionSet ss)
    throws java.rmi.RemoteException{
    runtime.removeBodySubscription(senderNode, ss);
  }


//-----------------------------------------------------------------------
// Inval Subscriptions
//-----------------------------------------------------------------------
  
  public void
  addInvalSubscription(NodeId senderNode, SubscriptionSet ss, 
                       boolean catchupWithCP)
    throws java.rmi.RemoteException{
    runtime.addInvalSubscription(senderNode, ss, catchupWithCP);
  }


  public void 
  removeInvalSubscription(NodeId senderNode, SubscriptionSet ss)
    throws java.rmi.RemoteException{
    runtime.removeInvalSubscription(senderNode, ss);
  }


  //---------------------------------------------------------------------------
  // Handling Demand Reads
  //---------------------------------------------------------------------------
   
  public void 
      demandRead(NodeId senderNode, ObjId objId, long offset, long length, AcceptStamp as)
    throws java.rmi.RemoteException {
      runtime.demandRead(senderNode, objId, offset, length, as);
  }


  //---------------------------------------------------------------------------
  // Requesting Sync
  //---------------------------------------------------------------------------
   
  public void
  requestSync(NodeId remoteNodeId, AcceptStamp acceptStamp)
    throws java.rmi.RemoteException {
    runtime.requestSync(remoteNodeId, acceptStamp);
  }

  public void
  requestSync(NodeId remoteNodeId, AcceptVV acceptVV)
    throws java.rmi.RemoteException {
    runtime.requestSync(remoteNodeId, acceptVV);
  }
    
    
  //---------------------------------------------------------------------------
  // Retreving the list of subscriptions
  //---------------------------------------------------------------------------
  
  public SubscriptionTable
  getEstablishedBodySubscriptions()
    throws java.rmi.RemoteException{
    return runtime.getEstablishedBodySubscriptions();
  }


  public SubscriptionTable
  getEstablishedInvalSubscriptions()
    throws java.rmi.RemoteException{
    return runtime.getEstablishedInvalSubscriptions();
  }
 
  public SubscriptionTable
  getEstablishedOutgoingBodySubscriptions()
    throws java.rmi.RemoteException{
    return runtime.getEstablishedOutgoingBodySubscriptions();
  }
 

  public SubscriptionTable
  getEstablishedOutgoingInvalSubscriptions()
    throws java.rmi.RemoteException{
    return runtime.getEstablishedOutgoingInvalSubscriptions();
  }
}

//---------------------------------------------------------------------------
/* $Log: RuntimeRMIServerImpl.java,v $
/* Revision 1.8  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.7  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.6  2007/02/01 06:12:09  zjiandan
/* Add acceptStamp to demandRead so that the sender only sends the data
/* that's at least as new as the acceptStamp.
/*
/* Revision 1.5  2007/01/05 01:18:41  nalini
/* support for sync with VV added
/*
/* Revision 1.4  2006/09/26 05:34:10  nalini
/* added sync interface to policy and runtime
/*
/* Revision 1.3  2006/08/31 23:36:58  nalini
/* minor code update
/*
/* Revision 1.2  2006/08/09 18:52:16  dahlin
/* Fixed Makefile to be portable to cygwin by fixing classpath definitions; fixed P2Runtime/Runtime v. java.lang.Runtime conflict by moving P2Runtime/Runtime to P2Runtime/P2Runtime
/*
/* Revision 1.1  2006/06/13 03:49:19  nalini
/* RMI for P2 Runtime Implemented
/*
 */
//---------------------------------------------------------------------------
