//---------------------------------------------------------------------------
/* SafetyLivenessBridge
 * 
 * Transfers msgs between safety and liveness policie
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.util.*;
import java.io.*;

public class SafetyLivenessBridge {
  Policy policy; // livness policy
  Hashtable mailBoxes;  // mailboxes for receiving msgs

  
  
  //---------------------------------------------------------------------------
  // constructor
  //---------------------------------------------------------------------------
  public SafetyLivenessBridge(Policy livenessPolicy){
    mailBoxes = new Hashtable();
    policy = livenessPolicy;
  }


  
  //---------------------------------------------------------------------------
  // registerMsgToListen
  // msgs need to be registered during initialization so that
  // mailboxes can be set up and
  // the corresponding tuples can be "subscribed" to from 
  // overlog 
  //---------------------------------------------------------------------------
  
  public void registerMsgToListen(String msgType){	
    MailBox mBox = new MailBox();
    mailBoxes.put(msgType, mBox);
    if(policy != null && policy instanceof OverlogPolicy) {
      OverlogPolicy oPolicy = (OverlogPolicy) policy;
      oPolicy.registerHandler(new SafetyTupleHandler(msgType, mBox));
    }
  }


  public void registerMsgToListen(String msgType, MsgMatcher matcher){	
    MailBox mBox = new MailBox(matcher);
    mailBoxes.put(msgType, mBox);
    if(policy != null && policy instanceof OverlogPolicy) {
      OverlogPolicy oPolicy = (OverlogPolicy) policy;
      oPolicy.registerHandler(new SafetyTupleHandler(msgType, mBox));
    }
  }
  

  //---------------------------------------------------------------------------
  // wait for a required Msg
  //---------------------------------------------------------------------------

  public void waitForLivenessMsg(String[] msg) {
    ((MailBox)mailBoxes.get(msg[0])).waitForMsg(msg);
  }


  //---------------------------------------------------------------------------
  // liveness policy calls this to send msg to the bridge 
  //---------------------------------------------------------------------------
  public void livenessToSafetyMsg(String[] msg){
    ((MailBox)mailBoxes.get(msg[0])).receiveMsg(msg);
  }


  //---------------------------------------------------------------------------
  // sending a message to liveness
  //---------------------------------------------------------------------------
  public void safetyToLivenessMsg(String[] msg){
    policy.receiveMsg(msg);
  }


  //---------------------------------------------------------------------------
  // Safety Tuple Handler
  // -- accepts tuples from Overlog Policy
  // -- Note: the safety tuple handler directly delivers the msg to 
  //    the mail box.  it does not need to go thro the SlBridge.
  //---------------------------------------------------------------------------
 
  public class SafetyTupleHandler extends TupleHandler {
    MailBox mBox;
    
    public SafetyTupleHandler(String msgType, MailBox mBox){
      super(msgType);
      this.mBox = mBox;
    }

    public void handleTuple(Tuple tp)
      throws MalformedTupleException {
      String[] msg = tp.getStringA();
      mBox.receiveMsg(msg);
    }
  }
}

//---------------------------------------------------------------------------
/* $Log: SafetyLivenessBridge.java,v $
/* Revision 1.2  2007/12/18 17:30:47  nalini
/* updated safetymodule
/*
/* Revision 1.1  2007/11/28 08:11:34  nalini
/* safety policy module and example checked in
/*
*/
//---------------------------------------------------------------------------