//---------------------------------------------------------------------------
/* Status.java
 * 
 *  Keeps track of the current status of the runtime
 *  including pending and established subscriptions,
 *  pending demandreads, pending ControllerInformMessages 
 *  and pending RuntimeCommands
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

//package p2;

public class Status {

  private BlockedQueue pendingControllerInformQueue;
  private BlockedQueue pendingPractiCommandQueue;

  private PendingBodySubscriptionQueue pendingBodySubscriptionQueue;
  private PendingInvalSubscriptionQueue pendingInvalSubscriptionQueue;

  private SubscriptionTable establishedBodySubscriptions;
  private SubscriptionTable establishedInvalSubscriptions;


  private SubscriptionTable establishedOutgoingBodySubscriptions;
  private SubscriptionTable establishedOutgoingInvalSubscriptions;
  
  
  private PendingDemandReadQueue pendingDemandReadQueue;


//---------------------------------------------------------------------------
//  Constructor
//---------------------------------------------------------------------------

  public
  Status(){

    pendingControllerInformQueue = new BlockedQueue();
    pendingPractiCommandQueue = new BlockedQueue();
 
    pendingBodySubscriptionQueue = 
      new PendingBodySubscriptionQueue();
    pendingInvalSubscriptionQueue = 
      new PendingInvalSubscriptionQueue();

    establishedBodySubscriptions = new SubscriptionTable();
    establishedInvalSubscriptions = new SubscriptionTable();

    establishedOutgoingBodySubscriptions = new SubscriptionTable();
    establishedOutgoingInvalSubscriptions = new SubscriptionTable();
 

    pendingDemandReadQueue = new PendingDemandReadQueue();
  }
//---------------------------------------------------------------------------
//  get Methods
//---------------------------------------------------------------------------
  public BlockedQueue
  getPendingControllerInformQueue() {
    return pendingControllerInformQueue;
  }

  public BlockedQueue
  getPendingPractiCommandQueue(){
    return pendingPractiCommandQueue;
  }

  public PendingBodySubscriptionQueue
  getPendingBodySubscriptionQueue(){
    return pendingBodySubscriptionQueue;
  }

  public PendingInvalSubscriptionQueue
  getPendingInvalSubscriptionQueue(){
    return pendingInvalSubscriptionQueue;
  }


  public SubscriptionTable
  getEstablishedBodySubscriptions(){
    return establishedBodySubscriptions;
  }

  public SubscriptionTable
  getEstablishedInvalSubscriptions(){
    return establishedInvalSubscriptions;
  }
 
  public SubscriptionTable
  getEstablishedOutgoingBodySubscriptions(){
    return establishedOutgoingBodySubscriptions;
  }

  public SubscriptionTable
  getEstablishedOutgoingInvalSubscriptions(){
    return establishedOutgoingInvalSubscriptions;
  }
  
  public PendingDemandReadQueue
  getPendingDemandReadQueue(){
    return pendingDemandReadQueue;
  }
}

//---------------------------------------------------------------------------
/* $Log: Status.java,v $
/* Revision 1.5  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.4  2007/03/06 23:57:09  nalini
/* changed code so that retries only occur when rmi error occur
/*
/* Revision 1.3  2006/10/02 23:23:39  nalini
/* synchronization support added
/*
/* Revision 1.2  2006/09/24 20:06:31  nalini
/* trying to make overlog and practi work
/*
*/
//---------------------------------------------------------------------------
