//---------------------------------------------------------------------------
/* SyncHandler.java
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class SyncHandler extends TupleHandler {

  private P2Runtime runtime;

  private boolean dbg = false|| P2Runtime.verboseHandlers;
 
  public SyncHandler(P2Runtime runtime){
    super("sync");
    this.runtime = runtime;
  }
 
  public void handleTuple(Tuple tp) {
    //Env.dprintln(dbg, "handleSync: " + tp);
    //<sync, myOverlogId, remoteOverlogId>
    NodeId remoteNodeId = NodeIdMap.getNodeId(new OverlogId(tp.getItem(2)));
    runtime.sync(remoteNodeId);
  }

}

//---------------------------------------------------------------------------
/* $Log: SyncHandler.java,v $
/* Revision 1.4  2007/09/12 19:08:12  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.3  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.2  2007/01/06 01:04:35  nalini
/* minor bug fixes for requestSync(VV)
/*
/* Revision 1.1  2007/01/05 01:19:54  nalini
/* support for sync with VV added
/*
 */
//---------------------------------------------------------------------------
