//---------------------------------------------------------------------------
/* TestClient.java
 * 
 * Carries out informal testing of the p2 related classes
 *
 * (C) Copyright 2004 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;
import java.lang.*;

public class TestClient{

  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){
    
    if(args.length < 2){
      System.out.println("Usage: TestClient <bchost> <bcport>");
      System.exit(-1);
    }

    String bcHost = args[0];
    int bcPort = (new Integer(args[1])).intValue();
 

    String path = "test" + File.separatorChar + "ClientServerTest.db";
    String configPath = "test" + File.separatorChar + "ClientServer.config";
    String p2ConfigPath = "test" + File.separatorChar + "ClientServer.p2.config";    
    //setupConfig(configPath, p2ConfigPath);
 

    NodeId serverNodeId = new NodeId(0);
    NodeId myNodeId = new NodeId(1);
    BarrierClient bc = new BarrierClient(bcHost,bcPort, 1);
    Policy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    AllReadBlockAllWriteBoundInterface lInterface = 
      new AllReadBlockAllWriteBoundInterface(runtime.getController(), runtime.getCore());
   
    
   try{
     //
     // test simple reads and writes
     // 
     final long SIZE = 100;
     byte b[] = new byte[(int)SIZE];
     for(int i = 0; i < SIZE; i++){
       b[i]=(byte)65; //"A"
     }
     ObjId o1 = new ObjId("/1");
     ObjId o2 = new ObjId("/2");
     ObjId o3 = new ObjId("/3");
     ObjId o4 = new ObjId("/4");

     System.out.println("Barrier 1: Client waiting for server to start");
     bc.sendBarrierRequest(-1, -1); // wait for server to start
     
    
     //establish subscriptions
     SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/*");
     runtime.addInvalSubscription(serverNodeId, ss, false);
     runtime.addBodySubscription(serverNodeId, ss);
     
     System.out.println("Barrier 2: Client established subscriptions");
     bc.sendBarrierRequest(-1, -1); // inform server that we have already established subs
     
     System.out.println("Barrier 3: Waiting for sever to write data");
     bc.sendBarrierRequest(-1, -1); // wait for server to write data
     
 
     //make sure we have got all the writes
     while(true){
	 try{
	     lInterface.sync(new AcceptStamp(3, serverNodeId));
	     break;
	 }catch(InterruptedException ie){
	     //ignore
	 }
     }
     System.out.println("Got all invals, trying to read data");
     /*
     try{
       Thread.sleep(500);
     }catch(InterruptedException e){
       System.err.println("" + e);
       assert(false);
     }
     System.out.println("Done sleeping");
     */
     
     //making sure the invals have been applied
     while(true){
	 try{
	     System.out.println(o1 + ":" + lInterface.read(o1, 0, SIZE));
	     break;
	 }catch(ObjNotFoundException e){
	     //ignore
	     Thread.currentThread().sleep(50);
	 }
     }
     while (true){
	 try{
	     System.out.println(o2 + ":" + lInterface.read(o2, 0, SIZE));
	     break;
	 }catch(ObjNotFoundException e){
	     //ignore
	     Thread.currentThread().sleep(50);
	 }
     }

     while(true){
	 try{
	     System.out.println(o3 + ":" + lInterface.read(o3, 0, SIZE));
	     break;
	 }catch(ObjNotFoundException e){
	     //ignore
	     Thread.currentThread().sleep(50);
	 }
     }
     
     while(true){
	 try{
	     System.out.println(o4 + ":" + lInterface.read(o4, 0, SIZE));
	     break;
	 }catch(ObjNotFoundException e){
	     //ignore
	     Thread.currentThread().sleep(50);
	 }
     }

     bc.sendBarrierRequest(-1, -1); // Tell server that we are done
     
     System.out.println("TestClient Done");
   }catch(Exception e){
     e.printStackTrace();
   }
    
  }


  private static void setupConfig(String configPath, String p2ConfigPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

   Config.addOneNodeConfig(new NodeId(1),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            "/tmp/ufs1",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

   Config.writeToFile(configPath);

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 3000, 3000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }
}


//---------------------------------------------------------------------------
/* $Log: TestClient.java,v $
/* Revision 1.10  2007/06/05 20:49:24  nalini
/* exposed LOG|CP option for invalSubscriptions to P2Runtime and Overlog layer
/*
/* Revision 1.9  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.8  2007/03/08 21:41:17  nalini
/* total revamp of P2Runtime, update subscriptions removed, retry logic changed
/*
/* Revision 1.7  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.6  2006/10/02 23:23:39  nalini
/* synchronization support added
/*
/* Revision 1.5  2006/08/09 18:52:16  dahlin
/* Fixed Makefile to be portable to cygwin by fixing classpath definitions; fixed P2Runtime/Runtime v. java.lang.Runtime conflict by moving P2Runtime/Runtime to P2Runtime/P2Runtime
/*
/* Revision 1.4  2006/04/23 20:06:43  nalini
/* *** empty log message ***
/*
/* Revision 1.1  2006/04/21 02:54:54  nalini
/* Initial version of P2 runtime. (merged with jiandan's callback code)
/*
 */
//---------------------------------------------------------------------------
