//---------------------------------------------------------------------------
/* TestDemandReadServer.java
 * 
 * Carries out informal testing of the p2 related classes
 * Test Demand Reads
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;

public class TestDemandReadServer{

  //---------------------------------------------------------------------------
  // Testing functions
  //---------------------------------------------------------------------------
 
  public static void main(String[] args){
    
    if(args.length < 2){
      System.out.println("Usage: TestServer <bchost> <bcport>");
      System.exit(-1);
    }

    String bcHost = args[0];
    int bcPort = (new Integer(args[1])).intValue();


    String path = "test" + File.separatorChar + "ClientServerTest.db";
    String configPath = "test" + File.separatorChar + "ClientServer.config";
    String p2ConfigPath = "test" + File.separatorChar + "ClientServer.p2.config";    
    setupConfig(configPath, p2ConfigPath);
 

    NodeId myNodeId = new NodeId(0);
    BarrierClient bc = new BarrierClient(bcHost,bcPort, 0);
    Policy policy = new NullPolicy();
    P2Runtime runtime = new P2Runtime(configPath, p2ConfigPath, myNodeId, true, policy, false);
    policy.setRuntime(runtime);
    runtime.start();
    AllReadBlockAllWriteUnboundInterface lInterface = 
      new AllReadBlockAllWriteUnboundInterface(runtime.getController(), runtime.getCore());
   
    
   try{
     //
     // test simple reads and writes
     // 
     final long SIZE = 100;
     byte b[] = new byte[(int)SIZE];
     for(int i = 0; i < SIZE; i++){
       b[i]=(byte)66; //"B"
     }
     ObjId o1 = new ObjId("/1");
     ObjId o2 = new ObjId("/2");
     ObjId o3 = new ObjId("/3");
     ObjId o4 = new ObjId("/4");

    
     System.out.println("Barrier 1: waiting for client to start");
     bc.sendBarrierRequest(-1, -1); // wait for client to start
    
     System.out.println("Barrier2: waiting for client to establish subscriptions");
     bc.sendBarrierRequest(-1, -1); // wait for client to carry out subscriptions

     lInterface.write(o1, 0, SIZE, b);
     lInterface.write(o2, 0, SIZE, b);
     lInterface.write(o3, 0, SIZE, b);
     lInterface.write(o4, 0, SIZE, b);
     
     System.out.println("Barrier 3: finished writing data");
     bc.sendBarrierRequest(-1, -1); // tell client finished writing
     System.out.println("Barrier 4: waiting for client to read data");
     bc.sendBarrierRequest(-1, -1); // wait for client to finish reading
     
     System.out.println("TestServer Done");
   }catch(Exception e){
     e.printStackTrace();
   }
    
  }


  private static void setupConfig(String configPath, String p2ConfigPath){
    Config.createEmptyConfig();
    Config.addOneNodeConfig(new NodeId(0),
                            "localhost",
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "/tmp/ufs0",
                            "/*",
                            -1L,
                            "localhost",
                            9993,
                            9994,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

   Config.addOneNodeConfig(new NodeId(1),
                            "localhost",
                            9888,
                            9889,
                            9891,
                            9892,
                            9890,
                            "/tmp/ufs1",
                            "/*",
                            -1L,
                            "localhost",
                            9893,
                            9894,
                            -1,
                            1000000,
                            Long.MAX_VALUE,
                             Long.MAX_VALUE);

   Config.writeToFile(configPath);

   P2Config.createEmptyConfig();
   P2Config.addOneNodeConfig(new NodeId(0), 5, 5, 30000, 30000, 2, 2, 2, 2, 2);
   P2Config.addOneNodeConfig(new NodeId(1), 5, 5, 30000, 30000, 2, 2, 2, 2, 2);
   P2Config.writeToFile(p2ConfigPath);
  }
}


//---------------------------------------------------------------------------
/* $Log: TestDemandReadServer.java,v $
/* Revision 1.8  2007/03/09 03:01:38  nalini
/* removed update workers option from P2Config
/*
/* Revision 1.7  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.6  2006/10/02 23:23:39  nalini
/* synchronization support added
/*
/* Revision 1.5  2006/08/09 18:52:16  dahlin
/* Fixed Makefile to be portable to cygwin by fixing classpath definitions; fixed P2Runtime/Runtime v. java.lang.Runtime conflict by moving P2Runtime/Runtime to P2Runtime/P2Runtime
/*
/* Revision 1.4  2006/04/23 20:06:43  nalini
/* *** empty log message ***
/*
/* Revision 1.1  2006/04/21 02:54:54  nalini
/* Initial version of P2 runtime. (merged with jiandan's callback code)
/*
 */
//---------------------------------------------------------------------------
