//---------------------------------------------------------------------------
/* Tuple.java
 *
 * Representation of an Overlog Tuple
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------
import java.util.*;

public class Tuple {
    
  String[] _tupleStrA;

//---------------------------------------------------------------------------
// Constructor for a string array
// Performanc Warning: it currently makes a new copy.  
// Do you think we can get away w/o making a new copy
//---------------------------------------------------------------------------
  public Tuple(String[] tupleStrA){
    _tupleStrA = new String[tupleStrA.length];
    for(int i = 0; i < _tupleStrA.length; i++){
      _tupleStrA[i] = tupleStrA[i];
    }
  }

//---------------------------------------------------------------------------
// Constructor for a  string
// 
//  Format for v.p2-0.8.1: tupleName(location, X, Y, Z) 
//---------------------------------------------------------------------------
  public Tuple(String tupleStr){
    
    int strIndex = tupleStr.indexOf("(");
    String tupleName = tupleStr.substring(0, strIndex);
    
    String str = tupleStr.substring(strIndex+1, tupleStr.length()-1);
    StringTokenizer tok = new StringTokenizer(str, ",");
	
    _tupleStrA = new String[tok.countTokens()+ 1];

    
    _tupleStrA[0] = tupleName;
    int i = 1;    
    while(tok.hasMoreTokens()){
      String token = tok.nextToken();
      // remove leading spaces
      int j;
      for(j = 0; j < token.length(); j++){
        if(!Character.isWhitespace(token.charAt(j))){
          break;
        }
      }
	    
      _tupleStrA[i++] = token.substring(j);
    }
  }

//---------------------------------------------------------------------------
// returns the tuple name
//---------------------------------------------------------------------------
  public String getTupleName(){
    return getItem(0);
  }

//---------------------------------------------------------------------------
// returns the string array representation of the tuple
//---------------------------------------------------------------------------
  public String[] getStringA(){
    return _tupleStrA;
  }

//---------------------------------------------------------------------------
// returns a single item of the tuple
//---------------------------------------------------------------------------
  public String getItem(int i){
    return _tupleStrA[i];
  }

//---------------------------------------------------------------------------
// returns the size of the tuple
//---------------------------------------------------------------------------
  public int getLength(){
    return _tupleStrA.length;
  }

//---------------------------------------------------------------------------
// returns the size of the tuple
//---------------------------------------------------------------------------
  public int getSize(){
    return _tupleStrA.length;
  }
//---------------------------------------------------------------------------
// returns the string represntatino of the tuple
//---------------------------------------------------------------------------
  public String toString(){
    String str = _tupleStrA[0]+"(";
    for(int i = 1; i < _tupleStrA.length - 1; i++){
      str+=_tupleStrA[i] + ",";
    }
    str += _tupleStrA[_tupleStrA.length-1] + ")";

    return str;
  }

//---------------------------------------------------------------------------
// equals
//---------------------------------------------------------------------------
  public boolean equals(Object o){
    if( !(o instanceof Tuple) ) {
      return false;
    }

    Tuple other = (Tuple) o;
    
    if (this._tupleStrA.length != other._tupleStrA.length) {
      return false;
    }


    for(int i = 0; i < this._tupleStrA.length; i++){
      if(!this._tupleStrA[i].equals(other._tupleStrA[i]))
        return false;
    }
    return true;
  }
} 

//---------------------------------------------------------------------------
/* $Log: Tuple.java,v $
/* Revision 1.4  2007/09/12 19:08:13  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.3  2007/07/11 20:25:53  nalini
/* persistent tuple support added
/*
/* Revision 1.2  2006/10/16 20:51:49  nalini
/* P2 tuple handler support added
/*
/* Revision 1.1  2006/09/19 22:18:27  nalini
/* P2 and Practi integration
/*
 */
//---------------------------------------------------------------------------