//---------------------------------------------------------------------------
/* TuplePollQueueWorkerThread
 * 
 * Picks an objId from the poll queue and reads it for new tuples
 * to insert into overlog
 *
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class TuplePollQueueWorkerThread extends Thread {
  private TuplePollQueue pQueue;
  private PersistentTupleInterface ptInterface;
  private boolean dbg = false;

  //-------------------------------------------------------------------------
  // Constructor
  //-------------------------------------------------------------------------
  public TuplePollQueueWorkerThread(TuplePollQueue pQueue,
                               PersistentTupleInterface ptInterface){
    this.pQueue = pQueue;
    this.ptInterface = ptInterface;
  }


  //-------------------------------------------------------------------------
  // takes an item from the queue and reads the tuples.
  //-------------------------------------------------------------------------

  public void run() {
    while(true) {
      // get item from the queue, read tuples, and then put it back into the
      // queue.
      PollItem pItem = pQueue.getNext();
      if(dbg) {
        Env.dprintln(dbg, "TuplePollWorkerThread: got pollItem"+ pItem);
      }

      ObjId objId = pItem.getObjId();
      ptInterface.tupleRead(objId);
      pQueue.add(pItem, true);
    }
  }
}

//---------------------------------------------------------------------------
/* $Log: TuplePollQueueWorkerThread.java,v $
/* Revision 1.1  2007/07/11 20:25:53  nalini
/* persistent tuple support added
/*
*/
//---------------------------------------------------------------------------

