//---------------------------------------------------------------------------
/* TupleReadAndWatchHandler
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class TupleReadAndWatchHandler extends TupleHandler {

  private PersistentTupleInterface ptInterface;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public TupleReadAndWatchHandler(PersistentTupleInterface ptInterface){
    super("tupleReadAndWatch");
    this.ptInterface = ptInterface;
  }
 
  public void handleTuple(Tuple tp) {
    //<tupleReadAndWatch, myOverlogId, objId, pollTime>
    if(dbg) Env.dprintln(dbg, "TupleReadAndWatchHandler: " + tp);

    ObjId objId;
    if(OverlogPolicy.P2VersionHasStringProblem){
      objId = new ObjId(tp.getItem(2).replaceAll("-", "/"));  
    }else {
      objId = new ObjId(tp.getItem(2));  
    }

    long pollTime = (new Long(tp.getItem(3))).longValue();
    ptInterface.tupleReadAndWatch(objId, pollTime);
  }

}

//---------------------------------------------------------------------------
/* $Log: TupleReadAndWatchHandler.java,v $
/* Revision 1.3  2007/09/12 19:08:13  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.2  2007/07/13 20:10:39  nalini
/* tuple*handlers debugged
/*
/* Revision 1.1  2007/07/11 20:25:53  nalini
/* persistent tuple support added
/*
 */
//---------------------------------------------------------------------------
