//---------------------------------------------------------------------------
/* TupleStopWatchHandler
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class TupleStopWatchHandler extends TupleHandler {

  private PersistentTupleInterface ptInterface;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public TupleStopWatchHandler(PersistentTupleInterface ptInterface){
    super("tupleStopWatch");
    this.ptInterface = ptInterface;
  }
 
  public void handleTuple(Tuple tp) {
    //tupleStopWatch, myOverlogId, objId>
    if(dbg) Env.dprintln(dbg, "TupleStopWatchHandler: " + tp);

    ObjId objId;
    if(OverlogPolicy.P2VersionHasStringProblem){
      objId = new ObjId(tp.getItem(2).replaceAll("-", "/"));  
    }else {
      objId = new ObjId(tp.getItem(2));  
    }

    ptInterface.tupleStopWatch(objId);
  }

}

//---------------------------------------------------------------------------
/* $Log: TupleStopWatchHandler.java,v $
/* Revision 1.3  2007/09/12 19:08:13  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.2  2007/07/13 20:10:39  nalini
/* tuple*handlers debugged
/*
/* Revision 1.1  2007/07/11 20:25:53  nalini
/* persistent tuple support added
/*
 */
//---------------------------------------------------------------------------
