//---------------------------------------------------------------------------
/* TupleWait.java
 * 
 * Implements methods which waits until the specificed tuples has been received
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class TupleWait extends  TupleHandler {
  private boolean dbg = false;

  private boolean rcvdTuple = false;
  
  private int numTuplesReceived = 0;
  
  public TupleWait(String tpName) {
    super(tpName);
  }
  
  
  public synchronized boolean waitForTuple() {
    //Env.dprintln(dbg, "TupleWait:: waiting for " + getTupleName());
    rcvdTuple = false;
    while(!rcvdTuple) {
      try{
        wait();
      }catch(InterruptedException e) {}
    }
    assert(rcvdTuple == true);
    return true;
  }
  
 
  public synchronized boolean waitForTuple(long timeout) {
    //Env.dprintln(dbg, "TupleWait:: waiting for " + getTupleName());
    rcvdTuple = false;
    try{
      wait(timeout);
    }catch(InterruptedException e) {}
    Env.dprintln(dbg, "TupleWait:: timed-out or received tuple");
    return rcvdTuple;
  }
      

  // note: this does not reset previous count -- use reset() to reset
  //  previous counts
  public synchronized boolean waitForMultipleTuples(int numRequired) {
    Env.dprintln(dbg, "TupleWait:: waiting for " + getTupleName());
    
    while(numTuplesReceived < numRequired) {
      Env.dprintln(dbg, "TupleWait:: numTuplesReceived = " + 
                   numTuplesReceived + "  numRequired = " + 
                   numRequired);
     try{
        wait();
      }catch(InterruptedException e) {}
    }
    assert(numTuplesReceived >= numRequired);
    return true;
  }

  public synchronized void resetCount(){
    numTuplesReceived = 0;
  }
    

  public synchronized void handleTuple(Tuple tp) 
    throws MalformedTupleException{
    //Env.dprintln(dbg, "TupleWait:: received " + tp);
    rcvdTuple = true;
    numTuplesReceived++;
    notifyAll();
  }

}

//---------------------------------------------------------------------------
/* $Log: TupleWait.java,v $
/* Revision 1.4  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.3  2007/03/19 03:14:11  nalini
/* added multipleTuple interface
/*
/* Revision 1.2  2007/03/14 01:01:35  nalini
/* added debugging output
/*
/* Revision 1.1  2007/03/13 23:20:31  nalini
/* added TupleWait barrier
/*
*/
//---------------------------------------------------------------------------