//---------------------------------------------------------------------------
/* TupleWriteHandler
 * 
 * (C) Copyright 2007 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

public class TupleWriteHandler extends TupleHandler {

  private PersistentTupleInterface ptInterface;

  private boolean dbg = false || P2Runtime.verboseHandlers;
 
  public TupleWriteHandler(PersistentTupleInterface ptInterface){
    super("tupleWrite");
    this.ptInterface = ptInterface;
  }
 
  public void handleTuple(Tuple tp) {
    //<tupleWrite, myOverlogId, objId, tupleName, myOverlogId, XX, YYY, ZZ, ...>
    // create the new tuple which needs to be written
    if(dbg) Env.dprintln(dbg, "TupleWriteHandler: " + tp);

    ObjId objId;
    if(OverlogPolicy.P2VersionHasStringProblem){
      objId = new ObjId(tp.getItem(2).replaceAll("-", "/"));  
    }else {
      objId = new ObjId(tp.getItem(2));  
    }

    String[] origStrA = tp.getStringA();
    String[] tpStrA = new String[origStrA.length - 3];
    
    for(int i = 0; i < tpStrA.length; i ++){
      tpStrA[i] = origStrA[i+3];
      if(OverlogPolicy.P2VersionHasStringProblem){
        tpStrA[i].replace('-', '/');
      }
    }
   
    ptInterface.tupleWrite(objId, new Tuple(tpStrA));
  }

}

//---------------------------------------------------------------------------
/* $Log: TupleWriteHandler.java,v $
/* Revision 1.3  2007/09/12 19:08:13  nalini
/* upgraded to p2-0.8.2
/*
/* Revision 1.2  2007/07/13 20:10:39  nalini
/* tuple*handlers debugged
/*
/* Revision 1.1  2007/07/11 20:25:53  nalini
/* persistent tuple support added
/*
 */
//---------------------------------------------------------------------------
