//---------------------------------------------------------------------------
/* URAOverlogNode.java
 *
 * Starts Practi and Overlog
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//---------------------------------------------------------------------------

import java.io.*;
import java.util.*;

public class URAOverlogNode {
  static boolean dbg = false;
  final protected OverlogPolicy overlogPolicy;
  final protected P2Runtime runtime;
  protected LocalInterface li;
  private boolean started = false;


//---------------------------------------------------------------------------
//  Constructor
//---------------------------------------------------------------------------

 public URAOverlogNode(String configPath, 
		       String p2ConfigPath, 
		       NodeId nodeId,
		       boolean cleanDb,
		       String overlogPath,
		       String nodeMapPath,
		       boolean noSyncLog){
   Env.dprintln(dbg, "creating URAOverlogNode");
   Config.readConfig(configPath);
   P2Config.readConfig(p2ConfigPath);
   overlogPolicy = new OverlogPolicy(overlogPath, nodeId, nodeMapPath);
   runtime = new P2Runtime(nodeId, cleanDb, overlogPolicy, noSyncLog);
   overlogPolicy.setRuntime(runtime);
   li = new LocalInterface(runtime.getController(), runtime.getCore());
   Env.dprintln(dbg, "create URAOverlogNode done");
  }

//---------------------------------------------------------------------------
// Starts Practi and Overlog
//---------------------------------------------------------------------------
 
  public void start()throws Exception {
    Env.dprintln(dbg, "starting URAOverlogNode");
    runtime.start();
    overlogPolicy.startOverlog();
    started = true;
    Env.dprintln(dbg, "start URAOverlogNode done");
  }


//---------------------------------------------------------------------------
// if noOverlog=true only starts practi.
//---------------------------------------------------------------------------
 
  public void start(boolean noOverlog)throws Exception {
    Env.dprintln(dbg, "starting URAOverlogNode");
    runtime.start();
    if(!noOverlog) {
      overlogPolicy.startOverlog();
    }
    started = true;
    Env.dprintln(dbg, "start URAOverlogNode done");
  }


//---------------------------------------------------------------------------
// shutsdown practi and overlog
//---------------------------------------------------------------------------
 
  public void shutdown()throws Exception {
    Env.dprintln(dbg, "shutting down URAOverlogNode");
    runtime.shutdown();
    overlogPolicy.stopOverlog();
    started = false;
    Env.dprintln(dbg, "shutting donw URAOverlogNode done");
  }
//---------------------------------------------------------------------------
// Register user-defined handlers for overlog tuples - should be called before start
//---------------------------------------------------------------------------
      
  public void registerHandler(TupleHandler th) {
    if(!started) {
      overlogPolicy.registerHandler(th);
    } else{
      assert(false): "OverlogPolicy: handlers must be registered before overlog started";
    }
  }

//---------------------------------------------------------------------------
// insert tuples into overlog
//---------------------------------------------------------------------------
      
  public void insertTuple(Tuple tp){
    if(started){
      overlogPolicy.insertTuple(tp);
    }else {
      assert(false): "OverlogPolicy: tuples can be inserted only after overlog has started";
    }
  }

//--------------------------------------------------------------------------
// Set Local Interface -- for customized local interface
//--------------------------------------------------------------------------
  public void setLocalInterface(LocalInterface li){
    this.li = li;
  }
  
//---------------------------------------------------------------------------
// Get method for runtime
//---------------------------------------------------------------------------

  public P2Runtime getP2Runtime(){
    return runtime;
  }

//--------------------------------------------------------------------------
// Get method for OverlogPolicy
//--------------------------------------------------------------------------
  public OverlogPolicy getOverlogPolicy(){
    return overlogPolicy;
  }

//--------------------------------------------------------------------------
// Get method for Local Interface
//--------------------------------------------------------------------------
  public LocalInterface getLocalInterface(){
    return li;
  }
  
//--------------------------------------------------------------------------
// Get method for myOverlogId
//--------------------------------------------------------------------------
  public OverlogId getMyOverlogId(){
    return overlogPolicy.getMyOverlogId();
  }

//--------------------------------------------------------------------------
// main method -- for testing
//--------------------------------------------------------------------------
  public static void main(String args[])throws Exception{ 
    if(args.length < 5) {
      System.out.println("Usage: URAOverlogNode <practiConfigPath> <p2ConfigPath> " +
			 "<nodeId> <overlogPath> <nodeMapPath>");
      
      return;
    }

    URAOverlogNode node = new URAOverlogNode(args[0], 
					     args[1],
					     new NodeId((new Long(args[2])).longValue()),
					     true,
					     args[3],
					     args[4],
					     false);
  try{
    node.start();
    
    
    Thread.currentThread().sleep(Long.MAX_VALUE);

    }catch(Exception e) {
      e.printStackTrace();
    }
  }
}

//---------------------------------------------------------------------------
/* $Log: URAOverlogNode.java,v $
/* Revision 1.12  2007/03/16 23:57:35  nalini
/* p2serverinterface added
/*
/* Revision 1.11  2007/03/09 23:01:24  zjiandan
/* Make IncommingConnection not kick off an object when receiving an impreciseinv
/* if the receiver's local lpvv is not "less" then the inv.endVV.
/*
/* Revision 1.10  2007/03/08 23:04:35  nalini
/* added main method
/*
/* Revision 1.9  2007/02/28 03:20:58  nalini
/* add parameter not to start overlog
/*
/* Revision 1.8  2007/02/12 06:19:49  zjiandan
/* Expose noSyncLog parameter, add more unittest for PRACTIFS, PangaeaFS.
/*
/* Revision 1.7  2007/01/18 23:46:04  nalini
/* minor update
/*
/* Revision 1.6  2007/01/12 19:12:05  nalini
/* minor updates
/*
/* Revision 1.5  2006/11/02 21:28:39  zjiandan
/* fixed some minor bugs and turn off the debug printing.
/*
/* Revision 1.4  2006/11/02 21:11:19  zjiandan
/* Fixed some bugs in URAOverlogNode and TupleHandlers.
/*
/* Revision 1.3  2006/10/25 23:34:38  zjiandan
/* Change URAOverlogNode to make it complete and self-contain to form a base
/* class for any PRACTI case-study system to start with.
/*
/* Revision 1.2  2006/10/18 22:13:56  nalini
/* added insert interface and checks if the node has started or not
/*
/* Revision 1.1  2006/10/18 21:57:11  nalini
/* URAOverlogNode added to  make it easier to start overlog and practi in one class
/*
*/
//---------------------------------------------------------------------------
