//---------------------------------------------------------------------------
/* UnbindCmd.java
 *
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */
//--------------------------------------------------------------------------

public class UnbindCmd extends PractiCommand {
 
  private ObjId objId;
  private long offset;
  private long length;
  private AcceptStamp as;

  private boolean dbg = false;
//--------------------------------------------------------------------------
// constructor
//--------------------------------------------------------------------------
  public UnbindCmd(ObjId objId,
                   long offset,
                   long length,
                   AcceptStamp as) {
    this.objId = objId;
    this.offset = offset;
    this.length = length;
    this.as = as;
  }
 
//--------------------------------------------------------------------------
// doCommand Method
//--------------------------------------------------------------------------
  public void doCommand(RMIClient rmiClient, Core core) throws Exception {
    //Env.dprintln(dbg, "UnbindCmd: Executing unbind for " + objId + ":" + offset
    //             + ":" + length + ":" + as);
    ObjInvalTarget objTarget = new ObjInvalTarget(objId, offset, length);
    UnbindMsg unbind = new UnbindMsg(objTarget, as);
    core.applyUnbind(unbind);
    Env.dprintln(dbg, "UnbindCmd: returning from core");
  }

//--------------------------------------------------------------------------
// toString method
//--------------------------------------------------------------------------
  public String toString() {
    return "UnbindCmd :" + objId + ", " + offset + ", " + length + 
      ", " + as;
  }
}

//---------------------------------------------------------------------------
/* $Log: UnbindCmd.java,v $
/* Revision 1.4  2007/04/02 21:06:48  zjiandan
/* fix Env.dprintln problems.
/*
/* Revision 1.3  2006/10/17 23:40:55  nalini
/* minor bug fixes and separated AS into individual components in overlog tuples
/*
/* Revision 1.2  2006/10/13 20:49:31  nalini
/* minor fixes
/*
/* Revision 1.1  2006/10/03 15:45:45  nalini
/* synchronization support added
/*
 */
//---------------------------------------------------------------------------
